<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <title>AppCo App Landing Page Template</title>

    <!--favicon icon-->
    <link rel="icon" href="{{ asset($hero->logo)}}" type="image/png" sizes="16x16">

    <!--google fonts-->
    <link href="https://fonts.googleapis.com/css?family=Montserrat:400,500,600,700%7COpen+Sans&display=swap"
          rel="stylesheet">

    <!--Bootstrap css-->
    <link rel="stylesheet" href="{{ asset('frontend/css/bootstrap.min.css')}}">
    <!--Magnific popup css-->
    <link rel="stylesheet" href="{{ asset('frontend/css/magnific-popup.css')}}">
    <!--Themify icon css-->
    <link rel="stylesheet" href="{{ asset('frontend/css/themify-icons.css')}}">
    <!--animated css-->
    <link rel="stylesheet" href="{{ asset('frontend/css/animate.min.css')}}">

    <!--Owl carousel css-->
    <link rel="stylesheet" href="{{ asset('frontend/css/owl.carousel.min.css')}}">
    <link rel="stylesheet" href="{{ asset('frontend/css/owl.theme.default.min.css')}}">
    <!--custom css-->
    <link rel="stylesheet" href="{{ asset('frontend/css/style.css')}}">
    <!--responsive css-->
    <link rel="stylesheet" href="{{ asset('frontend/css/responsive.css')}}">

</head>
<body>

<!--header section start-->
<header class="header">
    <!--start navbar-->
    <nav class="navbar navbar-expand-lg fixed-top bg-transparent">
        <div class="container">
            <a class="navbar-brand" href="{{ route('index') }}"><img src="{{ asset($hero->logo) }}"
                                                                     width="120" alt="logo"
                                                                     class="img-fluid"></a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                    data-bs-target="#navbarSupportedContent"
                    aria-controls="navbarSupportedContent" aria-expanded="false" aria-label="Toggle navigation">
                <span class="ti-menu"></span>
            </button>

            <div class="collapse navbar-collapse main-menu justify-content-end" id="navbarSupportedContent">
                <ul class="navbar-nav">
                    <li class="nav-item dropdown">
                        <a class="nav-link page-scroll" href="#" id="navbarDropdownHome" role="button">
                            Home
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link page-scroll" href="#about">About</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link page-scroll" href="#features">Features</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link page-scroll" href="#download">Download</a>
                    </li>

                    <li class="nav-item">
                        <a class="nav-link page-scroll" href="#screenshots">Screenshots</a>
                    </li>

                    @auth
                        @if(auth()->user()->role === 'admin')
                            <li class="nav-item">
                                <a class="nav-link" href="{{ route('admin.dashboard') }}">Dashboard</a>
                            </li>
                        @elseif(auth()->user()->role === 'retailer')
                            <li class="nav-item">
                                <a class="nav-link" href="{{ route('user.index') }}">Dashboard</a>
                            </li>
                        @endif
                    @else
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('login') }}">Login</a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" href="{{ route('register') }}">Register</a>
                        </li>
                    @endauth

                </ul>
            </div>
        </div>
    </nav>
    <!--end navbar-->
</header>
<!--header section end-->

<!--body content wrap start-->
<div class="main">

    <!--hero section start-->
    <section class="hero-section pt-100 background-img"
             style="background: url({{ asset($hero->h_bg_image) }})no-repeat center center / cover">
        <div class="container">
            <div class="row align-items-center justify-content-between g-4">
                <div class="col-md-6 col-lg-6">
                    <div class="hero-content-left text-white mt-5">
                        <span class="text-uppercase h6">{{ $hero->short_title }}</span>
                        <h1 class="text-white fw-bold">{{ $hero->title }}</h1>
                        <p class="lead">{{ $hero->short_description }}</p>

                        <a href="#download" class="btn app-store-btn">Download Now</a>
                    </div>
                </div>
                <div class="col-md-6 col-lg-5">
                    <div class="hero-animation-img">
                        <img src="{{ asset($hero->h_screenshot) }}" alt="img" class="img-fluid">
                    </div>
                </div>
            </div>
            <!--counter start-->
            <div class="row">
                <ul class="list-inline counter-wrap">
                    <li class="list-inline-item">
                        <div class="single-counter text-center">
                            <span>{{ $hero->total_clients }}</span>
                            <h6>Happy Client</h6>
                        </div>
                    </li>
                    <li class="list-inline-item">
                        <div class="single-counter text-center">
                            <span>{{ $hero->total_download }}</span>
                            <h6>App Download</h6>
                        </div>
                    </li>
                    <li class="list-inline-item">
                        <div class="single-counter text-center">
                            <span>{{ $hero->total_rates }}</span>
                            <h6>Total Rates</h6>
                        </div>
                    </li>
                    <li class="list-inline-item">
                        <div class="single-counter text-center">
                            <span>{{ $hero->total_awards }}</span>
                            <h6>Awards win</h6>
                        </div>
                    </li>
                </ul>
            </div>
            <!--counter end-->
        </div>
    </section>
    <!--hero section end-->

    <!--about us section start-->
    <section id="about" class="about-us ptb-100 gray-light-bg">
        <div class="container">
            <div class="row align-items-center justify-content-between g-4">
                <div class="col-lg-5">
                    <span class="text-uppercase color-secondary sub-title">{{ $about->short_title }}</span>
                    <h2>{{ $about->title }}</h2>
                    <p class="mb-4 lh-190">{!! $about->description !!} </p>
                </div>
                <div class="col-md-6">
                    <div class="about-content-right">
                        <img src="{{ asset($about->about_img) }}" width="500" alt="about us"
                             class="img-fluid">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--about us section end-->

    <!--features section start-->
    <div id="features" class="feature-section ptb-100">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="section-heading text-center mb-5">
                        <span class="text-uppercase color-secondary sub-title">{{ $feature->short_title }}</span>
                        <h2>{{ $feature->title }}</h2>
                        <p>{{ $feature->description }}</p>

                    </div>
                </div>
            </div>

            <!--feature new style start-->
            <div class="row row-grid align-items-center g-5">
                <div class="col-lg-4">
                    <div class="d-flex align-items-start mb-5">
                        <div class="pe-4">
                            <div class="icon icon-shape icon-color-1 rounded-circle">
                                <span class="ti-face-smile"></span>
                            </div>
                        </div>
                        <div class="icon-text">
                            <h5>{{ $feature->t_one }}</h5>
                            <p class="mb-0">{{ $feature->d_one }}</p>
                        </div>
                    </div>
                    <div class="d-flex align-items-start mb-5">
                        <div class="pe-4">
                            <div class="icon icon-shape icon-color-2 rounded-circle">
                                <span class="ti-vector"></span>
                            </div>
                        </div>
                        <div class="icon-text">
                            <h5>{{ $feature->t_two }}</h5>
                            <p class="mb-0">{{ $feature->d_two}}</p>
                        </div>
                    </div>
                    <div class="d-flex align-items-start">
                        <div class="pe-4">
                            <div class="icon icon-shape icon-color-3 rounded-circle">
                                <span class="ti-headphone-alt"></span>
                            </div>
                        </div>
                        <div class="icon-text">
                            <h5>{{ $feature->t_three }}</h5>
                            <p class="mb-0">{{ $feature->d_three }}</p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="position-relative" style="z-index: 10;">
                        <img alt="Image placeholder" src="{{ asset($feature->f_image) }}"
                             class="img-center img-fluid">
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="d-flex align-items-start mb-5">
                        <div class="pe-4">
                            <div class="icon icon-shape icon-color-4 rounded-circle">
                                <span class="ti-layout-media-right"></span>
                            </div>
                        </div>
                        <div class="icon-text">
                            <h5>{{ $feature->t_four }}</h5>
                            <p class="mb-0">{{ $feature->d_four }}</p>
                        </div>
                    </div>
                    <div class="d-flex align-items-start mb-5">
                        <div class="pe-4">
                            <div class="icon icon-shape icon-color-5 rounded-circle">
                                <span class="ti-layout-cta-right"></span>
                            </div>
                        </div>
                        <div class="icon-text">
                            <h5>{{ $feature->t_five }}</h5>
                            <p class="mb-0">{{ $feature->d_five }}</p>
                        </div>
                    </div>
                    <div class="d-flex align-items-start">
                        <div class="pe-4">
                            <div class="icon icon-shape icon-color-6 rounded-circle">
                                <span class="ti-palette"></span>
                            </div>
                        </div>
                        <div class="icon-text">
                            <h5>{{ $feature->t_six }}</h5>
                            <p class="mb-0">{{ $feature->d_six }}</p>
                        </div>
                    </div>
                </div>
            </div>
            <!--feature new style end-->
        </div>
    </div>
    <!--features section end-->


    <!--our video promo section start-->
    <section id="download" class="video-promo ptb-100 background-img"
             style="background: url({{ asset($hero->h_bg_image) }})no-repeat center center / cover">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-6">
                    <div class="video-promo-content mt-4 text-center">
                        <a href="{{ $download->video_url }}"
                           class="popup-youtube video-play-icon d-inline-block"><span class="ti-control-play"></span>
                        </a>
                        <h5 class="mt-4 text-white">Watch video overview</h5>

                        <div class="download-btn mt-5">
                            <a href="{{ route('apk.download') }}" class="btn google-play-btn me-3"><span
                                    class="ti-android"></span> Google
                                Play</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--our video promo section end-->

    <!--screenshots section start-->
    <section id="screenshots" class="screenshots-section ptb-100 gray-light-bg">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-8">
                    <div class="section-heading text-center">
                        <span class="text-uppercase color-secondary sub-title">{{ $ssSection->short_title }}</span>
                        <h2>{{ $ssSection->title }}</h2>
                        <p>{{ $ssSection->description }}</p>
                    </div>
                </div>
            </div>
            <!--start app screen carousel-->
            <div class="screen-slider-content mt-5">
                <div class="screenshot-frame"></div>
                <div class="screen-carousel owl-carousel owl-theme dot-indicator">
                    @foreach($screenshots as $screenshot)
                        <img src="{{ asset($screenshot->images)}}" class="img-fluid" alt="screenshots">
                    @endforeach
                </div>
            </div>
            <!--end app screen carousel-->

        </div>
    </section>
    <!--screenshots section end-->

</div>
<!--body content wrap end-->

<!--footer section start-->
<footer class="footer-section">

    <!--footer top start-->
    <div class="footer-top pt-150 background-img-2"
         style="background: url({{ asset('frontend/img/footer-bg.png') }})no-repeat center top / cover">
        <!--footer bottom copyright start-->
        <div class="footer-bottom border-gray-light mt-5 py-3">
            <div class="container">
                <div class="row">
                    <div class="col-md-6 col-lg-7">
                        <div class="copyright-wrap small-text">
                            <p class="mb-0 text-white">© {{ $settings->brandName }}</p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!--footer bottom copyright end-->
    </div>
    <!--footer top end-->
</footer>
<!--footer section end-->


<!--jQuery-->
<script src="{{ asset('frontend/js/jquery-3.6.1.min.js')}}"></script>
<!--Popper js-->
<script src="{{ asset('frontend/js/popper.min.js')}}"></script>
<!--Bootstrap js-->
<script src="{{ asset('frontend/js/bootstrap.min.js')}}"></script>
<!--Magnific popup js-->
<script src="{{ asset('frontend/js/jquery.magnific-popup.min.js')}}"></script>
<!--jquery easing js-->
<script src="{{ asset('frontend/js/jquery.easing.min.js')}}"></script>

<!--wow js-->
<script src="{{ asset('frontend/js/wow.min.js')}}"></script>
<!--owl carousel js-->
<script src="{{ asset('frontend/js/owl.carousel.min.js')}}"></script>
<!--countdown js-->
<script src="{{ asset('frontend/js/jquery.countdown.min.js')}}"></script>
<!--validator js-->
<script src="{{ asset('frontend/js/validator.min.js')}}"></script>
<!--custom js-->
<script src="{{ asset('frontend/js/scripts.js')}}"></script>
<script>
    // Disable right-click context menu
    document.addEventListener('contextmenu', event => event.preventDefault());

    document.onkeydown = function (event) {
        event = event || window.event;

        // Disable F12 (Inspect element)
        if (event.keyCode === 123) {
            return false;
        }

        // Allow Ctrl+C (67), Ctrl+X (88), Ctrl+V (86), Ctrl+Z (90), Ctrl+R (82), and F5 (116)
        // Check if Ctrl is held down and keycode is not in the allowed list
        if (event.ctrlKey && ![67, 82, 86, 88, 90].includes(event.keyCode)) {
            return false; // Block other Ctrl combinations
        }

        // Allow F5 (Refresh)
        if (event.keyCode === 116) {
            return true;
        }
    };

    // Prevent right-click using the mouse (right-click button)
    document.onmousedown = function (event) {
        if (event.button === 2) { // Right-click is button 2
            return false;
        }
    };

    // Fix for Ctrl+V not working in input elements
    document.onkeydown = function (event) {
        event = event || window.event;

        // Disable F12 (Inspect element)
        if (event.keyCode === 123) {
            return false;
        }

        // Allow Ctrl+C (67), Ctrl+X (88), Ctrl+V (86), Ctrl+Z (90), Ctrl+R (82), and F5 (116)
        // Allow Ctrl+V specifically in input and textarea
        if (event.ctrlKey && event.keyCode === 86 && (event.target.tagName === "INPUT" || event.target.tagName === "TEXTAREA")) {
            return true;  // Allow Ctrl+V in input or textarea
        }

        // Block other Ctrl key combinations
        if (event.ctrlKey && ![67, 82, 86, 88, 90].includes(event.keyCode)) {
            return false; // Block other Ctrl combinations
        }

        // Allow F5 (Refresh)
        if (event.keyCode === 116) {
            return true;
        }
    };

    // Prevent right-click using the mouse (right-click button)
    document.onmousedown = function (event) {
        if (event.button === 2) { // Right-click is button 2
            return false;
        }
    };

</script>
</body>
</html>
