@extends('main')
@section('h_title', 'Add Gateway')
@section('gateway_add', 'active')
@section('gateway_main', 'active')
@section('gateway_show', 'show')
@section('gateway_expanded', 'true')
@section('body')
    <div class="col-xxl-12 col-lg-12">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-lg-3">
                        <div class="nav nav-pills flex-column nav-pills-tab custom-verti-nav-pills text-center"
                             role="tablist" aria-orientation="vertical">
                            <a class="nav-link active show" id="custom-v-pills-bank-gateway-tab" data-bs-toggle="pill"
                               href="#custom-v-pills-bank-gateway" role="tab" aria-controls="custom-v-pills-home"
                               aria-selected="true">
                                <i class="ri-bank-line d-block fs-20 mb-1"></i> Bank Gateway
                            </a>
                            <a class="nav-link" id="custom-v-pills-mobile-gateway-tab" data-bs-toggle="pill"
                               href="#custom-v-pills-mobile-gateway" role="tab" aria-controls="custom-v-pills-profile"
                               aria-selected="false">
                                <i class="ri-smartphone-line d-block fs-20 mb-1"></i> Mobile Gateway
                            </a>
                            <a class="nav-link" id="custom-v-pills-auto-gateway-tab" data-bs-toggle="pill"
                               href="#custom-v-pills-auto-gateway" role="tab"
                               aria-controls="custom-v-pills-profile"
                               aria-selected="false">
                                <i class="ri-secure-payment-line d-block fs-20 mb-1"></i> Rongo Pay
                            </a>
                            <div class="text-center mt-2">
    <a href="https://control.rongoit.com/" target="_blank" class="btn btn-sm btn-outline-primary">
        <i class="ri-play-circle-line me-1"></i>Rongo Pay Link
    </a>
</div>
                        </div>
                    </div> <!-- end col-->
                    <div class="col-lg-9">
                        <div class="tab-content text-muted mt-3 mt-lg-0">
                            <div class="tab-pane fade active show" id="custom-v-pills-bank-gateway" role="tabpanel"
                                 aria-labelledby="custom-v-pills-bank-gateway-tab">

                                <form method="POST" action="{{ route('admin.add-gateway.bank.store') }}"
                                      enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-lg-8 col-md-10 col-sm-12">
                                            <div class="col-lg-10">
                                                <div class="mb-3">
                                                    <label for="name" class="form-label">Bank Name</label>
                                                    <input type="text" class="form-control" id="name" name="name"
                                                           oninput="generateSlug('name', 'slug')"
                                                           value="{{ old('name') }}"
                                                           placeholder="Bank Name">
                                                    @error('name')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-lg-10">
                                                <div class="mb-3">
                                                    <label for="slug" class="form-label">Slug</label>
                                                    <input type="text" class="form-control" id="slug" name="slug"
                                                           placeholder="auto generated" value="{{ old('slug') }}"
                                                           disabled>
                                                    @error('slug')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="col-lg-10">
                                                <div class="mb-3">
                                                    <label for="ac_holder" class="form-label">Account Holder</label>
                                                    <input type="text" class="form-control" id="ac_holder"
                                                           name="ac_holder"
                                                           value="{{ old('ac_holder') }}"
                                                           placeholder="Account Holder Name">
                                                    @error('ac_holder')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-lg-10">
                                                <div class="mb-3">
                                                    <label for="ac_number" class="form-label">Account Number</label>
                                                    <input type="text" class="form-control" id="ac_number"
                                                           name="ac_number"
                                                           value="{{ old('ac_number') }}"
                                                           placeholder="Account Number">
                                                    @error('ac_number')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-lg-10">
                                                <div class="mb-3">
                                                    <label for="ac_ibn" class="form-label">IBN</label>
                                                    <input type="text" class="form-control" id="ac_ibn" name="ac_ibn"
                                                           value="{{ old('ac_ibn') }}"
                                                           placeholder="IBN No.">
                                                    @error('ac_ibn')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-lg-10">
                                                <div class="mb-3">
                                                    <label for="branch_name" class="form-label">Branch Name</label>
                                                    <input type="text" class="form-control" id="branch_name"
                                                           name="branch_name"
                                                           value="{{ old('branch_name') }}"
                                                           placeholder="Branch Name">
                                                    @error('branch_name')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-lg-10">
                                                <div class="mb-3">
                                                    <label for="country" class="form-label">Country Name</label>
                                                    <input type="text" class="form-control" id="country" name="country"
                                                           value="{{ old('country') }}"
                                                           placeholder="Country Name">
                                                    @error('country')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-lg-10">
                                                <div class="mb-3">
                                                    <label for="lastnameInput" class="form-label">Logo</label>
                                                    <input class="form-control" type="file" id="logo" name="logo"
                                                           onchange="showPreview(event, 'logoPreviewSection', 'logoPreview')"/>
                                                    @error('logo')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="col-lg-10">
                                                <div class="form-check form-check-outline form-check-primary mb-3">
                                                    <input class="form-check-input" type="checkbox" id="formCheck19"
                                                           name="status"
                                                           checked>
                                                    <label class="form-check-label" for="formCheck19">
                                                        Status
                                                    </label>
                                                </div>
                                            </div>

                                            <!--end col-->
                                            <div class="col-lg-10">
                                                <div class="hstack gap-2 justify-content-end">
                                                    <button type="submit" class="btn btn-primary">Add</button>
                                                    <button type="button" class="btn btn-soft-success">Cancel</button>
                                                </div>
                                            </div>
                                            <!--end col-->
                                        </div>

                                        <!-- Logo Preview -->
                                        <div class="col-lg-4" id="logoPreviewSection" style="display: none;">
                                            <div class="col-lg-12">
                                                <span class="text-muted col-md-5" style="text-align: center">Logo Preview</span>
                                            </div>
                                            <div class="col-lg-12">
                                                <img id="logoPreview" height="250" width="250" src=""
                                                     alt="Logo Preview"/>
                                            </div>
                                        </div>
                                    </div>

                                </form>

                            </div>
                            <!--end tab-pane-->
                            <div class="tab-pane fade" id="custom-v-pills-mobile-gateway" role="tabpanel"
                                 aria-labelledby="custom-v-pills-mobile-gateway-tab">
                                <form method="POST" action="{{ route('admin.add-gateway.mobile.store') }}"
                                      enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-lg-8 col-md-10 col-sm-12">
                                            <div class="col-lg-10 ">
                                                <div class="mb-3">
                                                    <label for="m_name" class="form-label">Mobile Banking Name</label>
                                                    <input type="text" class="form-control" id="m_name" name="m_name"
                                                           oninput="generateSlug('m_name', 'm_slug')"
                                                           value="{{ old('m_name') }}"
                                                           placeholder="Mobile banking name">
                                                    @error('m_name')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-lg-10">
                                                <div class="mb-3">
                                                    <label for="m_slug" class="form-label">Slug</label>
                                                    <input type="text" class="form-control" id="m_slug" name="m_slug"
                                                           placeholder="auto generated" value="{{ old('m_slug') }}"
                                                           disabled>
                                                    @error('m_slug')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="col-lg-10">
                                                <div class="mb-3">
                                                    <label for="number" class="form-label">Number</label>
                                                    <input type="number" class="form-control" id="number"
                                                           name="m_number"
                                                           value="{{ old('m_number') }}"
                                                           placeholder="Mobile banking number">
                                                    @error('m_number')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-lg-10">
                                                <div class="mb-3">
                                                    <label for="type" class="form-label">Add Money Type</label>
                                                    <select id="type" class="form-select" name="type">
                                                        <option selected disabled>Choose...</option>
                                                        <option>Cash In</option>
                                                        <option>Cash Out</option>
                                                        <option>Payment</option>
                                                        <option>Send Money</option>
                                                    </select>

                                                    @error('type')
                                                    <span class="text-danger mt-2">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <!--end col-->

                                            <div class="col-lg-10">
                                                <div class="mb-3">
                                                    <label for="lastnameInput" class="form-label">Logo</label>
                                                    <input class="form-control" type="file" id="logo" name="m_logo"
                                                           onchange="showPreview(event, 'mlogoPreviewSection', 'mlogoPreview')"/>
                                                    @error('m_logo')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="col-lg-10">
                                                <div class="form-check form-check-outline form-check-primary mb-3">
                                                    <input class="form-check-input" type="checkbox" id="formCheck19"
                                                           name="status"
                                                           checked>
                                                    <label class="form-check-label" for="formCheck19">
                                                        Status
                                                    </label>
                                                </div>
                                            </div>

                                            <!--end col-->
                                            <div class="col-lg-10">
                                                <div class="hstack gap-2 justify-content-end">
                                                    <button type="submit" class="btn btn-primary">Add</button>
                                                    <button type="button" class="btn btn-soft-success">Cancel</button>
                                                </div>
                                            </div>
                                            <!--end col-->
                                        </div>

                                        <!-- Logo Preview -->
                                        <div class="col-lg-4" id="mlogoPreviewSection" style="display: none;">
                                            <div class="col-lg-12">
                                                <span class="text-muted col-md-5" style="text-align: center">Logo Preview</span>
                                            </div>
                                            <div class="col-lg-12">
                                                <img id="mlogoPreview" height="250" width="250" src=""
                                                     alt="Logo Preview"/>
                                            </div>
                                        </div>
                                    </div>

                                </form>
                            </div>
                            <!--end tab-pane-->

                            <!--end tab-pane-->
                            <div class="tab-pane fade" id="custom-v-pills-auto-gateway" role="tabpanel"
                                 aria-labelledby="custom-v-pills-auto-gateway-tab">
                                <form method="POST" action="{{ route('admin.add-gateway.update.auto.gateway') }}">
                                    @csrf
                                    @method('PUT')
                                    <div class="row">
                                        <div class="col-lg-8 col-md-10 col-sm-12">
                                            <div class="col-lg-10 ">
                                                <div class="mb-3">
                                                    <label for="m_name" class="form-label">API/Brand Key</label>
                                                    <input type="text" class="form-control" id="brand_key"
                                                           name="brand_key"
                                                           value="{{ $gateway->api_key }}"
                                                           placeholder="Brand Key">
                                                    @error('brand_key')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>


                                            <!--end col-->
                                            <div class="col-lg-10">
                                                <div class="hstack gap-2 justify-content-end">
                                                    <button type="submit" class="btn btn-primary">Update</button>
                                                </div>
                                            </div>
                                            <!--end col-->
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <!--end tab-pane-->
                        </div>
                    </div> <!-- end col-->
                </div> <!-- end row-->
            </div><!-- end card-body -->
        </div>
        <!--end card-->
    </div>
@endsection
@push('js')
    <script>
        function generateSlug(getName, setSlug) {
            const nameInput = document.getElementById(getName);
            const slugInput = document.getElementById(setSlug);

            // Get the value from the name input
            const name = nameInput.value.trim();

            // Generate a slug: convert to lowercase, replace spaces with hyphens, remove non-alphanumeric characters except hyphens
            const slug = name
                .toLowerCase()
                .replace(/\s+/g, '-') // Replace spaces with hyphens
                .replace(/[^\w-]+/g, ''); // Remove non-alphanumeric characters except hyphens

            // Set the slug value to the slug input field
            slugInput.value = slug;
        }

        function showPreview(event, section, logoView) {
            const previewSection = document.getElementById(section);
            const logoPreview = document.getElementById(logoView);
            const file = event.target.files[0];

            if (file) {
                // Show the preview section
                previewSection.style.display = 'block';

                // Create a URL for the selected file and set it as the image source
                const reader = new FileReader();
                reader.onload = function (e) {
                    logoPreview.src = e.target.result;
                }
                reader.readAsDataURL(file);
            } else {
                // Hide the preview section if no file is selected
                previewSection.style.display = 'none';
            }
        }
    </script>
@endpush
