@extends('main')
@section('h_title', 'Edit Gateway')
@section('gateway_view', 'active')
@section('gateway_main', 'active')
@section('gateway_show', 'show')
@section('gateway_expanded', 'true')
@section('body')

    <div class="col-xxl-11 col-md-10">
        <div class="card">
            <div class="card-header align-items-center d-flex">
                <h4 class="card-title mb-0 flex-grow-1">Edit <b class="text-danger">{{ $bank->bank_name }}</b></h4>
            </div><!-- end card header -->
            <div class="card-body">
                <form method="POST" action="{{ route('admin.add-gateway.bank.update', $bank->id) }}"
                      enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="row">
                        <div class="col-lg-8 col-md-10 col-sm-12">
                            <div class="col-lg-10">
                                <div class="mb-3">
                                    <label for="name" class="form-label">Bank Name</label>
                                    <input type="text" class="form-control" id="name" name="name"
                                           oninput="generateSlug('name', 'slug')"
                                           value="{{ $bank->bank_name }}"
                                           placeholder="Bank Name">
                                    @error('name')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-10">
                                <div class="mb-3">
                                    <label for="slug" class="form-label">Slug</label>
                                    <input type="text" class="form-control" id="slug" name="slug"
                                           placeholder="auto generated" value="{{ $bank->slug }}"
                                           disabled>
                                    @error('slug')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-lg-10">
                                <div class="mb-3">
                                    <label for="ac_holder" class="form-label">Account Holder</label>
                                    <input type="text" class="form-control" id="ac_holder"
                                           name="ac_holder"
                                           value="{{ $bank->ac_holder_name }}"
                                           placeholder="Account Holder Name">
                                    @error('ac_holder')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-10">
                                <div class="mb-3">
                                    <label for="ac_number" class="form-label">Account Number</label>
                                    <input type="text" class="form-control" id="ac_number"
                                           name="ac_number"
                                           value="{{ $bank->ac_holder_number }}"
                                           placeholder="Account Number">
                                    @error('ac_number')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-10">
                                <div class="mb-3">
                                    <label for="ac_ibn" class="form-label">IBN</label>
                                    <input type="text" class="form-control" id="ac_ibn" name="ac_ibn"
                                           value="{{ $bank->ibn_no }}"
                                           placeholder="IBN No.">
                                    @error('ac_ibn')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-10">
                                <div class="mb-3">
                                    <label for="branch_name" class="form-label">Branch Name</label>
                                    <input type="text" class="form-control" id="branch_name"
                                           name="branch_name"
                                           value="{{ $bank->branch_name }}"
                                           placeholder="Branch Name">
                                    @error('branch_name')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-10">
                                <div class="mb-3">
                                    <label for="country" class="form-label">Country Name</label>
                                    <input type="text" class="form-control" id="country" name="country"
                                           value="{{ $bank->country_name }}"
                                           placeholder="Country Name">
                                    @error('country')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-10">
                                <div class="mb-3">
                                    <label for="lastnameInput" class="form-label">Logo</label>
                                    <input class="form-control" type="file" id="logo" name="logo"
                                           onchange="showPreview(event, 'logoPreviewSection', 'logoPreview')"/>
                                    @error('logo')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-lg-10">
                                <div class="form-check form-check-outline form-check-primary mb-3">
                                    <input class="form-check-input" type="checkbox" id="formCheck19"
                                           name="status"
                                        {{ $bank->status == 1 ? 'checked' : '' }}>
                                    <label class="form-check-label" for="formCheck19">
                                        Status
                                    </label>
                                </div>
                            </div>

                            <!--end col-->
                            <div class="col-lg-10">
                                <div class="hstack gap-2 justify-content-end">
                                    <button type="submit" class="btn btn-primary">Update</button>
                                    <button type="button" class="btn btn-soft-success">Cancel</button>
                                </div>
                            </div>
                            <!--end col-->
                        </div>

                        <!-- Logo Preview -->
                        <div class="col-lg-4" id="logoPreviewSection">
                            <div class="col-lg-12">
                                <span class="text-muted col-md-5" style="text-align: center">Logo Preview</span>
                            </div>
                            <div class="col-lg-12">
                                <img id="logoPreview" height="250" width="250" src="{{ asset($bank->logo) }}"
                                     alt="Logo Preview"/>
                            </div>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

@endsection
@push('js')
    <script>
        function generateSlug(getName, setSlug) {
            const nameInput = document.getElementById(getName);
            const slugInput = document.getElementById(setSlug);

            // Get the value from the name input
            const name = nameInput.value.trim();

            // Generate a slug: convert to lowercase, replace spaces with hyphens, remove non-alphanumeric characters except hyphens
            const slug = name
                .toLowerCase()
                .replace(/\s+/g, '-') // Replace spaces with hyphens
                .replace(/[^\w-]+/g, ''); // Remove non-alphanumeric characters except hyphens

            // Set the slug value to the slug input field
            slugInput.value = slug;
        }

        function showPreview(event, section, logoView) {
            const previewSection = document.getElementById(section);
            const logoPreview = document.getElementById(logoView);
            const file = event.target.files[0];

            if (file) {
                // Show the preview section
                previewSection.style.display = 'block';

                // Create a URL for the selected file and set it as the image source
                const reader = new FileReader();
                reader.onload = function (e) {
                    logoPreview.src = e.target.result;
                }
                reader.readAsDataURL(file);
            } else {
                // Hide the preview section if no file is selected
                previewSection.style.display = 'none';
            }
        }
    </script>
@endpush
