@extends('main')
@section('h_title', 'Edit Gateway')
@section('gateway_view', 'active')
@section('gateway_main', 'active')
@section('gateway_show', 'show')
@section('gateway_expanded', 'true')
@section('body')

    <div class="col-xxl-11 col-md-10">
        <div class="card">
            <div class="card-header align-items-center d-flex">
                <h4 class="card-title mb-0 flex-grow-1">Edit <b class="text-danger">{{ $mobile->name }}</b></h4>
            </div><!-- end card header -->
            <div class="card-body">
                <form method="POST" action="{{ route('admin.add-gateway.mobile.update', $mobile->id) }}"
                      enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="row">
                        <div class="col-lg-8 col-md-10 col-sm-12">
                            <div class="col-lg-10 ">
                                <div class="mb-3">
                                    <label for="m_name" class="form-label">Mobile Banking Name</label>
                                    <input type="text" class="form-control" id="m_name" name="m_name"
                                           oninput="generateSlug('m_name', 'm_slug')"
                                           value="{{ $mobile->name }}"
                                           placeholder="Mobile banking name">
                                    @error('m_name')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-10">
                                <div class="mb-3">
                                    <label for="m_slug" class="form-label">Slug</label>
                                    <input type="text" class="form-control" id="m_slug" name="m_slug"
                                           placeholder="auto generated" value="{{ $mobile->slug }}"
                                           disabled>
                                    @error('m_slug')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-lg-10">
                                <div class="mb-3">
                                    <label for="number" class="form-label">Number</label>
                                    <input type="number" class="form-control" id="number"
                                           name="m_number"
                                           value="{{ $mobile->number }}"
                                           placeholder="Mobile banking number">
                                    @error('m_number')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-10">
                                <div class="mb-3">
                                    <label for="type" class="form-label">Add Money Type</label>
                                    <select id="type" class="form-select" name="type">
                                        <option selected disabled>Choose...</option>
                                        <option {{ $mobile->sending_type == 'Cash In' ? 'selected' : '' }}>Cash In
                                        </option>
                                        <option {{ $mobile->sending_type == 'Cash Out' ? 'selected' : '' }}>Cash Out
                                        </option>
                                        <option {{ $mobile->sending_type == 'Payment' ? 'selected' : '' }}>Payment
                                        </option>
                                        <option {{ $mobile->sending_type == 'Send Money' ? 'selected' : '' }}>Send
                                            Money
                                        </option>
                                    </select>

                                    @error('type')
                                    <span class="text-danger mt-2">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-10">
                                <div class="mb-3">
                                    <label for="lastnameInput" class="form-label">Logo</label>
                                    <input class="form-control" type="file" id="logo" name="m_logo"
                                           onchange="showPreview(event, 'mlogoPreviewSection', 'mlogoPreview')"/>
                                    @error('m_logo')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-lg-10">
                                <div class="form-check form-check-outline form-check-primary mb-3">
                                    <input class="form-check-input" type="checkbox" id="formCheck19"
                                           name="status"
                                        {{ $mobile->status == 1 ? 'checked' : '' }}>
                                    <label class="form-check-label" for="formCheck19">
                                        Status
                                    </label>
                                </div>
                            </div>

                            <!--end col-->
                            <div class="col-lg-10">
                                <div class="hstack gap-2 justify-content-end">
                                    <button type="submit" class="btn btn-primary">Update</button>
                                    <button type="button" class="btn btn-soft-success">Cancel</button>
                                </div>
                            </div>
                            <!--end col-->
                        </div>

                        <!-- Logo Preview -->
                        <div class="col-lg-4" id="mlogoPreviewSection">
                            <div class="col-lg-12">
                                <span class="text-muted col-md-5" style="text-align: center">Logo Preview</span>
                            </div>
                            <div class="col-lg-12">
                                <img id="mlogoPreview" height="250" width="250" src="{{ asset($mobile->logo) }}"
                                     alt="Logo Preview"/>
                            </div>
                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>

@endsection
@push('js')
    <script>
        function generateSlug(getName, setSlug) {
            const nameInput = document.getElementById(getName);
            const slugInput = document.getElementById(setSlug);

            // Get the value from the name input
            const name = nameInput.value.trim();

            // Generate a slug: convert to lowercase, replace spaces with hyphens, remove non-alphanumeric characters except hyphens
            const slug = name
                .toLowerCase()
                .replace(/\s+/g, '-') // Replace spaces with hyphens
                .replace(/[^\w-]+/g, ''); // Remove non-alphanumeric characters except hyphens

            // Set the slug value to the slug input field
            slugInput.value = slug;
        }

        function showPreview(event, section, logoView) {
            const previewSection = document.getElementById(section);
            const logoPreview = document.getElementById(logoView);
            const file = event.target.files[0];

            if (file) {
                // Show the preview section
                previewSection.style.display = 'block';

                // Create a URL for the selected file and set it as the image source
                const reader = new FileReader();
                reader.onload = function (e) {
                    logoPreview.src = e.target.result;
                }
                reader.readAsDataURL(file);
            } else {
                // Hide the preview section if no file is selected
                previewSection.style.display = 'none';
            }
        }
    </script>
@endpush
