@extends('main')
@section('h_title', 'All Gateway')
@section('gateway_view', 'active')
@section('gateway_main', 'active')
@section('gateway_show', 'show')
@section('gateway_expanded', 'true')
@push('css_cdn')
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css"/>
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css"/>
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">
@endpush
@section('body')
    <div class="col-xxl-11 col-md-10">
        <div class="card">
            <div class="card-body">
                <!-- Nav tabs -->
                <ul class="nav nav-tabs nav-tabs-custom nav-info nav-justified mb-3 col-lg-4" role="tablist">
                    <li class="nav-item">
                        <a class="nav-link active" data-bs-toggle="tab" href="#mobile_gateway" role="tab">
                            Mobile Gateway
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" data-bs-toggle="tab" href="#bank_gateway" role="tab">
                            Bank Gateway
                        </a>
                    </li>
                </ul>

                <!-- Tab panes -->
                <div class="tab-content text-muted">
                    <div class="tab-pane active" id="mobile_gateway" role="tabpanel">
                        <table id="mobile_gateway_table" class="table nowrap align-middle">
                            <thead>
                            <tr>
                                <th scope="col" style="width: 10px;">
                                    <div class="form-check">
                                        <input class="form-check-input fs-15" type="checkbox" id="checkAll"
                                               value="option">
                                    </div>
                                </th>
                                <th data-ordering="false">SR No.</th>
                                <th data-ordering="false">Logo</th>
                                <th data-ordering="false">Name</th>
                                <th data-ordering="false">Slug</th>
                                <th data-ordering="false">Method Number</th>
                                <th data-ordering="false">Gateway Type</th>
                                <th data-ordering="false">Status</th>
                                <th>Created At</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($m_gateways as $data)
                                <tr>
                                    <th scope="row">
                                        <div class="form-check">
                                            <input class="form-check-input fs-15" type="checkbox"
                                                   name="checkAll"
                                                   value="option1">
                                        </div>
                                    </th>
                                    <td>{{ $loop->iteration }}</td>
                                    <td><img src="{{ asset($data->logo) }}" alt="{{ $data->name }}"
                                             style="height: 50px; width: 50px;"></td>
                                    <td>{{ $data->name }}</td>
                                    <td>{{ $data->slug }}</td>
                                    <td>{{ $data->number }}</td>
                                    <td>{{ $data->sending_type }}</td>
                                    <td>
                                        <button style="width: 50px;"
                                                class="btn btn-{{ $data->status == 1 ? 'primary' : 'danger' }} waves-effect waves-light btn-sm">{{ $data->status == 1 ? 'On' : 'Off' }}</button>

                                    </td>
                                    <td>{{ \Carbon\Carbon::make($data->created_at)->format('D, d M Y') }}</td>
                                    <td>
                                        <a href="{{ route('admin.add-gateway.mobile.edit', $data->id) }}"
                                           class="btn btn-outline-primary btn-icon waves-effect waves-light"><i
                                                class="ri-edit-box-line"></i></a>
                                        <a href="{{ route('admin.add-gateway.mobile.delete', $data->id) }}"
                                           class="btn btn-outline-danger btn-icon waves-effect waves-light remove-item-btn"><i
                                                class="ri-delete-bin-line"></i></a>
                                    </td>
                                </tr>
                            @endforeach

                            </tbody>
                        </table>
                    </div>
                    <div class="tab-pane" id="bank_gateway" role="tabpanel">
                        <table id="scroll-horizontal" class="table nowrap align-middle">
                            <thead>
                            <tr>
                                <th scope="col" style="width: 10px;">
                                    <div class="form-check">
                                        <input class="form-check-input fs-15" type="checkbox" id="checkAll"
                                               value="option">
                                    </div>
                                </th>
                                <th data-ordering="false">SR No.</th>
                                <th data-ordering="false">Logo</th>
                                <th data-ordering="false">Name</th>
                                <th data-ordering="false">Slug</th>
                                <th data-ordering="false">A/C Holder Name</th>
                                <th data-ordering="false">A/C Holder Number</th>
                                <th data-ordering="false">Branch</th>
                                <th data-ordering="false">Status</th>
                                <th>Created At</th>
                                <th>Action</th>
                            </tr>
                            </thead>
                            <tbody>
                            @foreach($b_gateways as $data)
                                <tr>
                                    <th scope="row">
                                        <div class="form-check">
                                            <input class="form-check-input fs-15" type="checkbox"
                                                   name="checkAll"
                                                   value="option1">
                                        </div>
                                    </th>
                                    <td>{{ $loop->iteration }}</td>
                                    <td><img src="{{ asset($data->logo) }}" alt="{{ $data->name }}"
                                             style="height: 50px; width: 50px;"></td>
                                    <td>{{ $data->bank_name }}</td>
                                    <td>{{ $data->slug }}</td>
                                    <td>{{ $data->ac_holder_name }}</td>
                                    <td>{{ $data->ac_holder_number }}</td>
                                    <td>{{ $data->branch_name }}</td>
                                    <td>
                                        <button style="width: 50px;"
                                                class="btn btn-{{ $data->status == 1 ? 'primary' : 'danger' }} waves-effect waves-light btn-sm">{{ $data->status == 1 ? 'On' : 'Off' }}</button>

                                    </td>
                                    <td>{{ \Carbon\Carbon::make($data->created_at)->format('D, d M Y') }}</td>
                                    <td>
                                        <a href="{{ route('admin.add-gateway.bank.edit', $data->id) }}"
                                           class="btn btn-outline-primary btn-icon waves-effect waves-light"><i
                                                class="ri-edit-box-line"></i></a>
                                        <a href="{{ route('admin.add-gateway.bank.delete', $data->id) }}"
                                           class="btn btn-outline-danger btn-icon waves-effect waves-light remove-item-btn"><i
                                                class="ri-delete-bin-line"></i></a>
                                    </td>
                                </tr>
                            @endforeach

                            </tbody>
                        </table>
                    </div>
                </div>
            </div><!-- end card-body -->
        </div><!-- end card -->
    </div>
@endsection
@push('js_cdn')

    <script src="https://code.jquery.com/jquery-3.7.1.min.js" crossorigin="anonymous"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

    <script src="{{ asset('assets/js/pages/datatables.init.js')}}"></script>
@endpush
@push('js')
    <script>
        $(document).ready(function() {
            // Initialize DataTable for the mobile gateway table
            if (!$.fn.DataTable.isDataTable('#mobile_gateway_table')) {
                $('#mobile_gateway_table').DataTable({
                    responsive: true,
                    ordering: true,
                    lengthChange: true,
                    autoWidth: false,
                    paging: true
                });
            }

        /*    // Initialize DataTable for the bank gateway table
            if (!$.fn.DataTable.isDataTable('#bank_gateway_table')) {
                $('#bank_gateway_table').DataTable({
                    responsive: true,
                    ordering: true,
                    lengthChange: true,
                    autoWidth: false,
                    paging: true
                });
            }*/
        });

        $(document).on("click", ".remove-item-btn", function (e) {
            e.preventDefault(); // Prevent default action
            var link = $(this).attr('href'); // Get the href attribute

            Swal.fire({
                title: "Are you sure?",
                text: "You can't restore the item",
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: "Yes, delete",
                cancelButtonText: "Cancel",
                buttonsStyling: false,
                customClass: {
                    confirmButton: 'btn btn-primary w-xs me-2 mt-2',
                    cancelButton: 'btn btn-danger w-xs mt-2'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire({
                        title: "Deleted!",
                        text: "Item has been deleted.",
                        icon: "success",
                        confirmButtonClass: "btn btn-primary w-xs mt-2",
                        buttonsStyling: false
                    }).then(() => {
                        window.location.href = link; // Redirect after showing success message
                    });
                }
            });
        });
    </script>
@endpush
