<!DOCTYPE html>
<html lang="zxx">
<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <link rel="stylesheet" href="{{ asset('assets/css/google-icon.css')}}">
    <link rel="stylesheet" href="{{ asset('assets/css/remixicon.css')}}">
    <link href="{{ asset('assets/css/icons.css') }}"
          rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="{{ asset('assets/css/style.css')}}">

    <!-- Title -->
    <title>@yield('title') | CodeCollection</title>

</head>
<body class="boxed-size">

<!-- Start Main Content Area -->
<div class="container-fluid">
    <header class="header-area bg-white mb-4" id="header-area" style="padding: 15px 15px">
        <div class="row align-items-center">
            <div class="col-lg-4 col-sm-6">
                <div class="left-header-content">
                    <ul class="d-flex align-items-center ps-0 mb-0 list-unstyled justify-content-center justify-content-sm-start">
                        <li>
                            <div class="logo position-relative">
                                <a href="#" class="d-block text-decoration-none position-relative">
                                    <img src="{{ asset('assets/images/logo-light.png')}}" alt="logo-icon"
                                         style="height: 25px">
                                </a>
                            </div>
                        </li>
                    </ul>
                </div>
            </div>

            <div class="col-lg-8 col-sm-6">
                <div class="right-header-content mt-2 mt-sm-0">
                    <ul class="d-flex align-items-center justify-content-center justify-content-sm-end ps-0 mb-0 list-unstyled">
                        <li class="header-right-item">
                            <a href="https://wa.me/message/MH2R6RW6UO6DI1" target="_blank" class="btn btn-primary text-white" type="button">
                                Help
                            </a>
                        </li>
                    </ul>
                </div>
            </div>
        </div>
    </header>
    <div class="main-content-container overflow-hidden">

        <div class="row justify-content-center">
            <div class="col-lg-6">
                <div class="card bg-white border-0 rounded-3 mb-4">
                    <div class="card-body p-4">
                        <div class="tab-content" id="myTab2Content">
                            <div class="tab-pane fade show active" id="preview2-tab-pane" role="tabpanel"
                                 aria-labelledby="preview2-tab" tabindex="0">
                                <ul class="nav nav-tabs justify-content-between border-0 mb-4 wizard-tabs2"
                                    id="myTabstep2" role="tablist">
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link p-0 d-flex align-items-center @yield('requirements')"
                                                type="button">
                                            <span
                                                class="fs-18 text-primary wh-35 bg-primary bg-opacity-10 rounded-circle d-flex justify-content-center align-items-center">1</span>
                                            <div class="text-start ms-1 d-none d-lg-flex align-items-center">
                                                <h4 class="fs-16 fw-semibold m-0">Requirements</h4>
                                            </div>
                                        </button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link p-0 d-flex align-items-center @yield('database')"
                                                id="database-tab"
                                                type="button">
                                            <span
                                                class="fs-18 fw-bold text-primary wh-35 bg-primary bg-opacity-10 rounded-circle d-flex justify-content-center align-items-center">2</span>
                                            <div class="text-start ms-3 d-none d-lg-flex align-items-center">
                                                <h4 class="fs-16 fw-semibold m-0">Database</h4>
                                            </div>
                                        </button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link p-0 d-flex align-items-center @yield('import')"
                                                type="button">
                                            <span
                                                class="fs-18 fw-bold text-primary wh-35 bg-primary bg-opacity-10 rounded-circle d-flex justify-content-center align-items-center">3</span>
                                            <div class="text-start ms-3 d-none d-lg-flex align-items-center">
                                                <h4 class="fs-16 fw-semibold m-0">Import</h4>
                                            </div>
                                        </button>
                                    </li>
                                    <li class="nav-item" role="presentation">
                                        <button class="nav-link p-0 d-flex align-items-center @yield('finish')"
                                                type="button">
                                            <span
                                                class="fs-18 fw-bold text-primary wh-35 bg-primary bg-opacity-10 rounded-circle d-flex justify-content-center align-items-center">4</span>
                                            <div class="text-start ms-3 d-none d-lg-flex align-items-center">
                                                <h4 class="fs-16 fw-semibold m-0">Finish</h4>
                                            </div>
                                        </button>
                                    </li>
                                </ul>

                                <div class="tab-content" id="myTabstep2Content">
                                    <div class="tab-pane fade show active">
                                        @yield('installer-body')
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

<!-- Link Of JS File -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="{{ asset('assets/js/custom/custom.js')}}"></script>
<script>
    // Disable right-click context menu
    document.addEventListener('contextmenu', event => event.preventDefault());

    // Disable specific keyboard shortcuts, but allow Ctrl+C, Ctrl+X, Ctrl+V, Ctrl+Z, Ctrl+R, and F5
    document.onkeydown = function (event) {
        event = event || window.event;

        // Disable F12 (Inspect element)
        if (event.keyCode === 123) {
            return false;
        }

        // Allow only Ctrl+C (67), Ctrl+X (88), Ctrl+V (86), Ctrl+Z (90), Ctrl+R (82), and F5 (116)
        if (event.ctrlKey && ![67, 82, 86, 88, 90].includes(event.keyCode)) {
            return false;
        }

        // Allow F5 (Refresh)
        if (event.keyCode === 116) {
            return true;
        }
    };

    // Prevent right-click using the mouse (right-click button)
    document.onmousedown = function (event) {
        if (event.button === 2) { // Right-click is button 2
            return false;
        }
    };
</script>

</body>
</html>
