@extends('installer.app')
@section('title', 'Database')
@section('requirements', 'active')
@section('database', 'active')
@section('installer-body')

    <div class="row">

        <div class="col-lg-12">
            <div class="form-group mb-4">
                <p class="text-dark mb-0">Enter your database details. You can read the docs included with the
                    script files to learn how to create the database, lease do not use the hashtag "#" or spaces on the
                    database details</p>
            </div>

            @if (session('success'))
                <div class="form-group mb-4">
                    <div class="alert alert-success alert-dismissible" role="alert">
                        {{ session('success') }}
                        <button type="button" class="btn-close shadow-none" data-bs-dismiss="alert"
                                aria-label="Close"></button>
                    </div>
                </div>
            @elseif(session('error'))
                <div class="form-group mb-4">
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close shadow-none" data-bs-dismiss="alert"
                                aria-label="Close"></button>
                    </div>
                </div>
            @endif


            <form action="{{ route('installer.install') }}" method="POST">
                @csrf

                <div class="form-group mb-4">
                    <label class="label">Database host: <span class="text-danger">*</span></label>
                    <div class="form-group position-relative">
                        <input type="text" class="form-control text-dark ps-5 h-55" placeholder="Enter database host"
                               name="db_host"
                               value="localhost" required>
                        <i class="ri-server-fill position-absolute top-50 start-0 translate-middle-y fs-20 text-gray-light ps-20"></i>
                    </div>
                    @error('db_host')
                    <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group mb-4">
                    <label class="label">Database name: <span class="text-danger">*</span></label>
                    <div class="form-group position-relative">
                        <input type="text" class="form-control text-dark ps-5 h-55" placeholder="Enter database name"
                               value="{{ old('db_name') }}"
                               name="db_name"
                               required>
                        <i class="ri-database-2-fill position-absolute top-50 start-0 translate-middle-y fs-20 text-gray-light ps-20"></i>
                    </div>
                    @error('db_name')
                    <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>
                <div class="form-group mb-4">
                    <label class="label">Database username: <span class="text-danger">*</span></label>
                    <div class="form-group position-relative">
                        <input type="text" class="form-control text-dark ps-5 h-55"
                               placeholder="Enter database username" name="db_user" value="{{ old('db_user') }}"
                               required>
                        <i class="ri-user-fill position-absolute top-50 start-0 translate-middle-y fs-20 text-gray-light ps-20"></i>
                    </div>
                    @error('db_user')
                    <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>
                <div class="form-group mb-4">
                    <label class="label">Database password:</label>
                    <div class="form-group position-relative">
                        <input type="text" class="form-control text-dark ps-5 h-55" name="db_password"
                               value="{{ old('db_password') }}"
                               placeholder="Enter database password">
                        <i class="ri-key-fill position-absolute top-50 start-0 translate-middle-y fs-20 text-gray-light ps-20"></i>
                    </div>
                </div>
                <div class="col-lg-12">
                    <div class="form-group">
                        <button type="submit"
                                class="btn btn-primary py-3 px-5 fw-semibold text-white btn-sm">Next <i
                                class="mdi mdi-arrow-right"></i></button>
                    </div>
                </div>
            </form>

        </div>
    </div>
@endsection
