@extends('installer.app')
@section('title', 'Finished')
@section('requirements', 'active')
@section('database', 'active')
@section('import', 'active')
@section('finish', 'active')
@section('installer-body')
    <div class="row">
        <div class="col-lg-12">
            <div class="form-group mb-4">
                <p class="text-dark mb-0">Enter your admin panel name and access details</p>
            </div>

            @if(session('error'))
                <div class="form-group mb-4">
                    <div class="alert alert-danger alert-dismissible" role="alert">
                        {{ session('error') }}
                        <button type="button" class="btn-close shadow-none" data-bs-dismiss="alert"
                                aria-label="Close"></button>
                    </div>
                </div>
            @endif

            <form action="{{ route('installer.installation-finished') }}" method="POsT">
                @csrf
                <div class="form-group mb-4">
                    <label class="label">Admin Panel Name: <span class="text-danger">*</span></label>
                    <div class="form-group position-relative">
                        <input type="text" class="form-control text-dark ps-5 h-55" placeholder="Admin Panel Name"
                               value="{{ old('app_name') }}"
                               name="app_name" required>
                        <i class="ri-global-fill position-absolute top-50 start-0 translate-middle-y fs-20 text-gray-light ps-20"></i>
                    </div>
                    @error('app_name')
                    <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group mb-4">
                    <label class="label">Android Package Name: <span class="text-danger">*</span></label>
                    <div class="form-group position-relative">
                        <input type="text" class="form-control text-dark ps-5 h-55"
                               placeholder="Enter android package name"
                               value="{{ old('app_package_name') }}"
                               name="app_package_name"
                               required>
                        <i class="ri-android-fill position-absolute top-50 start-0 translate-middle-y fs-20 text-gray-light ps-20"></i>
                    </div>
                    @error('app_package_name')
                    <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>
                <div class="form-group mb-4">
                    <label class="label">Admin Url: <span class="text-danger">*</span></label>
                    <div class="form-group position-relative">
                        <input type="text" class="form-control text-dark ps-5 h-55" placeholder="Enter admin url"
                               value="{{ old('app_url') }}"
                               name="app_url"
                               required>
                        <i class="ri-link position-absolute top-50 start-0 translate-middle-y fs-20 text-gray-light ps-20"></i>
                    </div>
                    @error('app_url')
                    <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>

                {{--      <div class="form-group mb-4">
                          <label class="label">Admin Username: <span class="text-danger">*</span></label>
                          <div class="form-group position-relative">
                              <input type="text" class="form-control text-dark ps-5 h-55" placeholder="Enter admin username"
                                     required>
                              <i class="ri-user-fill position-absolute top-50 start-0 translate-middle-y fs-20 text-gray-light ps-20"></i>
                          </div>
                      </div>--}}

                <div class="form-group mb-4">
                    <label class="label">Admin Email: <span class="text-danger">*</span></label>
                    <div class="form-group position-relative">
                        <input type="text" class="form-control text-dark ps-5 h-55" placeholder="Enter admin email"
                               value="{{ old('admin_email') }}"
                               name="admin_email"
                               required>
                        <i class="ri-mail-fill position-absolute top-50 start-0 translate-middle-y fs-20 text-gray-light ps-20"></i>
                    </div>
                    @error('admin_email')
                    <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>
                <div class="form-group mb-4">
                    <label class="label">Admin Password: <span class="text-danger">8 digits *</span></label>
                    <div class="form-group position-relative">
                        <input type="password" class="form-control text-dark ps-5 h-55"
                               placeholder="Enter admin password"
                               name="admin_password" required>
                        <i class="ri-lock-fill position-absolute top-50 start-0 translate-middle-y fs-20 text-gray-light ps-20"></i>
                    </div>
                    @error('admin_password')
                    <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>

                <div class="form-group mb-4">
                    <label class="label">Confirm Admin Password: <span class="text-danger">8 digits *</span></label>
                    <div class="form-group position-relative">
                        <input type="password" class="form-control text-dark ps-5 h-55"
                               placeholder="Confirm admin password"
                               name="admin_confirm_password" required>
                        <i class="ri-lock-fill position-absolute top-50 start-0 translate-middle-y fs-20 text-gray-light ps-20"></i>
                    </div>
                    @error('admin_confirm_password')
                    <span class="text-danger">{{ $message }}</span>
                    @enderror
                </div>

                <div class="col-lg-12">
                    <div class="form-group">
                        <button type="submit"
                                class="btn btn-primary py-3 px-5 fw-semibold text-white btn-sm">Finish <i
                                class="ri-arrow-right-line"></i></button>
                    </div>
                </div>
            </form>
        </div>
    </div>
@endsection
