@extends('installer.app')
@section('title', 'Requirements')
@section('requirements', 'active')
@section('database', 'active')
@section('import', 'active')
@section('installer-body')

    <div class="form-group mb-4">
        <p class="text-dark mb-0">Import your database, some servers may not support this feature or have problems, so
            we recommend using manual import if you encounter a problem with automatic import</p>
    </div>
    <ul class="nav nav-tabs mb-4" id="myTab" role="tablist">
        <li class="nav-item" role="presentation">
            <button class="nav-link active" id="home-tab" data-bs-toggle="tab" data-bs-target="#autoimport-tab-pane"
                    type="button" role="tab" aria-controls="autoimport-tab-pane" aria-selected="true"><i
                    class="ri-import-line"></i> Auto Import
            </button>
        </li>
        <li class="nav-item" role="presentation">
            <button class="nav-link" id="manual-import-tab" data-bs-toggle="tab" data-bs-target="#manual-import-tab-pane"
                    type="button" role="tab" aria-controls="manual-import-tab-pane" aria-selected="false">Manual Import
            </button>
        </li>

    </ul>
    <div class="tab-content" id="myTabContent">
        <div class="tab-pane fade show active" id="autoimport-tab-pane" role="tabpanel" aria-labelledby="autoimport-tab"
             tabindex="0">

            <h4>Importing your database automatically, click import now</h4>
            <div class="col-lg-12">
                <div class="form-group">
                    <a href="{{ route('installer.db-import') }}"
                       class="btn btn-primary py-3 px-5 fw-semibold text-white btn-sm"><i class="ri-upload-line"></i>
                        Import</a>
                </div>
            </div>

            <div class="alert alert-danger mt-4" role="alert">
                <h4 class="alert-heading">Important Notice!</h4>
                <hr>
                <p class="mb-0">Auto import is not supported on some servers, if you click import and you get 500 Error
                    that means your server does not support it, please use the manual import.</p>
            </div>

        </div>
        <div class="tab-pane fade" id="manual-import-tab-pane" role="tabpanel" aria-labelledby="manual-import-tab" tabindex="0">
            <h4>Importing your database Manually, follow the steps</h4>
            <hr>
            <h6>1 - Download the SQL file </h6>
            <div class="col-lg-12">
                <div class="form-group">
                    <a href="{{ route('installer.db-download') }}"
                       class="btn btn-warning py-3 px-5 fw-semibold text-white btn-sm"><i class="ri-download-line"></i>
                        Download SQL file</a>
                </div>
            </div>

            <hr>
            <h6>2 - Follow this steps</h6>
            <div class="col-md-8">
                <img src="{{ asset('assets/images/database-steps.png') }}" alt="code" style="height: 200px;"/>
            </div>
            <hr>
            <h6>3 - After importing the database, click Skip to the next step</h6>
            <div class="col-lg-12">
                <div class="form-group">
                    <a href="{{ route('installer.skip') }}" class="btn btn-primary py-3 px-5 fw-semibold text-white btn-sm">Skip to next step <i
                            class="ri-arrow-right-line"></i></a>
                </div>
            </div>

            <div class="alert alert-primary text-primary mt-2" role="alert">
                <i class="ri-home-7-line fs-18 me-1"></i>
                Make sure you import the database before clicking skip to next step
            </div>
        </div>
    </div>

@endsection
