@extends('installer.app')
@section('title', 'Requirements')
@section('requirements', 'active')
@section('installer-body')
    <ul class="list-group mb-3">
        @foreach($requirements as $requirement => $result)
            <li class="list-group-item d-flex justify-content-between align-items-center border-0"
                style="background: none">
                {{ $requirement }}


                <span class="material-symbols-outlined text-{{ $result ? 'success' : 'danger' }}">
                {{ $result ? 'task_alt' : 'block' }}
                </span>

            </li>
        @endforeach
    </ul>

    <div class="col-lg-12">
        <div class="form-group">
            <a href="{{route('installer.update-requirements')}}"
               class="btn btn-primary py-3 px-5 fw-semibold text-white btn-sm {{ !$isEnabled ? 'disabled' : '' }}">Next <i class="ri-arrow-right-line"></i></a>
        </div>
    </div>
@endsection
