<!doctype html>
<html lang="en" data-layout="vertical" data-layout-style="detached" data-sidebar="light" data-topbar="dark"
      data-sidebar-size="lg" data-sidebar-image="none" data-preloader="disable">

<head>

    <meta charset="utf-8"/>
    <title>@yield('h_title')</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta content="Codecollection" name="Md Aynal Haque"/>
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <!-- App favicon -->
    <link rel="shortcut icon" href="{{ asset($settings->brandFavicon)}}">

    <!-- jsvectormap css -->
    <link href="{{ asset('assets/libs/jsvectormap/css/jsvectormap.min.css')}}" rel="stylesheet" type="text/css"/>

    <!--Swiper slider css-->
    <link href="{{ asset('assets/libs/swiper/swiper-bundle.min.css')}}" rel="stylesheet" type="text/css"/>
    @stack('css_cdn')
    <link href="{{ asset('assets/libs/sweetalert2/sweetalert2.min.css')}}" rel="stylesheet" type="text/css"/>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/toastify-js/src/toastify.min.css">
    <!-- Layout config Js -->
    <script src="{{ asset('assets/js/layout.js')}}"></script>
    <!-- Bootstrap Css -->
    <link href="{{ asset('assets/css/bootstrap.min.css')}}" rel="stylesheet" type="text/css"/>
    <!-- Icons Css -->
    <link href="{{ asset('assets/css/icons.min.css')}}" rel="stylesheet" type="text/css"/>
    <!-- App Css-->
    <link href="{{ asset('assets/css/app.min.css')}}" rel="stylesheet" type="text/css"/>
    <!-- custom Css-->
    <link href="{{ asset('assets/css/custom.min.css')}}" rel="stylesheet" type="text/css"/>
    @stack('css')
    <script src="https://www.gstatic.com/firebasejs/8.3.2/firebase.js"></script>

</head>

<body>

<!-- Begin page -->
<div id="layout-wrapper">

    @include('body.header')
    <!-- ========== App Menu ========== -->
    @include('body.sidebar')
    <!-- Left Sidebar End -->
    <!-- Vertical Overlay-->
    <div class="vertical-overlay"></div>

    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="main-content">

        <div class="page-content">
            <div class="container-fluid">

                @yield('body')

            </div>
            <!-- container-fluid -->
        </div>
        <!-- End Page-content -->

        @include('body.footer')
    </div>
    <!-- end main content-->

</div>
<!-- END layout-wrapper -->


<!--start back-to-top-->
<button onclick="topFunction()" class="btn btn-danger btn-icon" id="back-to-top">
    <i class="ri-arrow-up-line"></i>
</button>
<!--end back-to-top-->

<!--preloader-->
<div id="preloader">
    <div id="status">
        <div class="spinner-border text-primary avatar-sm" role="status">
            <span class="visually-hidden">Loading...</span>
        </div>
    </div>
</div>

<!-- JAVASCRIPT -->
<script src="{{ asset('assets/libs/bootstrap/js/bootstrap.bundle.min.js')}}"></script>
<script src="{{ asset('assets/libs/simplebar/simplebar.min.js')}}"></script>
<script src="{{ asset('assets/libs/node-waves/waves.min.js')}}"></script>
<script src="{{ asset('assets/libs/feather-icons/feather.min.js')}}"></script>
<script src="{{ asset('assets/js/pages/plugins/lord-icon-2.1.0.js')}}"></script>
<script src="{{ asset('assets/js/plugins.js')}}"></script>

<!-- apexcharts -->
<script src="{{ asset('assets/libs/apexcharts/apexcharts.min.js')}}"></script>

<!-- Vector map-->
<script src="{{ asset('assets/libs/jsvectormap/js/jsvectormap.min.js')}}"></script>
<script src="{{ asset('assets/libs/jsvectormap/maps/world-merc.js')}}"></script>

<!--Swiper slider js-->
<script src="{{ asset('assets/libs/swiper/swiper-bundle.min.js')}}"></script>

<!-- Dashboard init -->
<script src="{{ asset('assets/js/pages/dashboard-ecommerce.init.js')}}"></script>
<!-- Sweet Alerts js -->
<script src="{{ asset('assets/libs/sweetalert2/sweetalert2.min.js')}}"></script>
<!-- Sweet alert init js-->
<script src="{{ asset('assets/js/pages/sweetalerts.init.js')}}"></script>
<script src="https://cdn.jsdelivr.net/npm/toastify-js"></script>
@stack('js_cdn')

<!-- App js -->
<script src="{{ asset('assets/js/app.js')}}"></script>

<!-- FontAwesome CDN -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" />

<script>
    document.addEventListener('DOMContentLoaded', function () {
        // Firebase configuration
        const firebaseConfig = {
            apiKey: "{{ env('FIREBASE_API_KEY') }}",
            authDomain: "{{ env('FIREBASE_AUTH_DOMAIN') }}",
            projectId: "{{ env('FIREBASE_PROJECT_ID') }}",
            {{--storageBucket: "{{ env('FIREBASE_STORAGE_BUCKET') }}",--}}
            messagingSenderId: "{{ env('FIREBASE_MESSAGING_SENDER_ID') }}",
            appId: "{{ env('FIREBASE_APP_ID') }}",
            measurementId: "{{ env('FIREBASE_MEASUREMENT_ID') }}"
        };

        // Initialize Firebase
        firebase.initializeApp(firebaseConfig);

        const messaging = firebase.messaging();

        // Register the service worker
        if ('serviceWorker' in navigator) {
            navigator.serviceWorker.register('/firebase-messaging-sw.js')
                .then((registration) => {
                    // Request permission and get the device token
                    messaging.requestPermission()
                        .then(() => {
                            return messaging.getToken({
                                vapidKey: "{{env('FIREBASE_WEB_PUSH_CERTIFICATE_KEY')}}"
                            });
                        })
                        .then((token) => {
                            if (token) {
                                console.log('token: ', token);
                                // Use AJAX to submit the token
                                fetch('{{ route('admin.update.token') }}', {
                                    method: 'PUT',
                                    headers: {
                                        'Content-Type': 'application/json',
                                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                                    },
                                    body: JSON.stringify({fcm_token: token})
                                })
                                    .then(response => response.json())
                                    .then(data => {
                                        console.log('token updated: ', data);
                                    })
                                    .catch(error => {
                                        console.error('token error: ', error);
                                    });
                            } else {
                                console.error('No registration token available. Request permission to generate one.');
                            }
                        })
                        .catch((err) => {
                            console.error('An error occurred while retrieving token.', err);
                        });
                })
                .catch((error) => {
                    console.error('Service Worker registration failed:', error);
                });
        } else {
            console.error('Service Workers are not supported in this browser.');
        }

        // Handle incoming messages
        messaging.onMessage((payload) => {
            console.log('Message received. ', payload);
            const notificationTitle = payload.notification.title;
            const notificationOptions = {
                body: payload.notification.body,
                icon: payload.notification.icon
            };

            if (Notification.permission === 'granted') {
                new Notification(notificationTitle, notificationOptions);
            }
        });
    });
</script>

@stack('js')


@if (Session::has('message'))
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const message = "{{ Session::get('message') }}";
            const type = "{{ Session::get('alert-type', 'info') }}"; // Use 'info' as default type

            let toastOptions = {
                text: message,
                duration: 3000, // Duration in milliseconds
                gravity: "top", // 'top' or 'bottom'
                position: 'right', // 'left' or 'right'
                stopOnFocus: true // Prevent toast from hiding on hover
            };

            // Customize options based on the message type
            switch (type) {
                case 'success':
                    toastOptions.backgroundColor = "#28a745"; // Solid green for success
                    break;
                case 'error':
                    toastOptions.backgroundColor = "#dc3545"; // Solid red for error
                    break;
                case 'warning':
                    toastOptions.backgroundColor = "#ffc107"; // Solid yellow for warning
                    break;
                default:
                    toastOptions.backgroundColor = "#6c757d"; // Default solid color (gray)
            }

            Toastify(toastOptions).showToast();
        });
    </script>
@endif
{{--<script>
    // Disable right-click context menu
    document.addEventListener('contextmenu', event => event.preventDefault());

    document.onkeydown = function (event) {
        event = event || window.event;

        // Disable F12 (Inspect element)
        if (event.keyCode === 123) {
            return false;
        }

        // Allow Ctrl+C (67), Ctrl+X (88), Ctrl+V (86), Ctrl+Z (90), Ctrl+R (82), and F5 (116)
        // Check if Ctrl is held down and keycode is not in the allowed list
        if (event.ctrlKey && ![67, 82, 86, 88, 90].includes(event.keyCode)) {
            return false; // Block other Ctrl combinations
        }

        // Allow F5 (Refresh)
        if (event.keyCode === 116) {
            return true;
        }
    };

    // Prevent right-click using the mouse (right-click button)
    document.onmousedown = function (event) {
        if (event.button === 2) { // Right-click is button 2
            return false;
        }
    };

    // Fix for Ctrl+V not working in input elements
    document.onkeydown = function (event) {
        event = event || window.event;

        // Disable F12 (Inspect element)
        if (event.keyCode === 123) {
            return false;
        }

        // Allow Ctrl+C (67), Ctrl+X (88), Ctrl+V (86), Ctrl+Z (90), Ctrl+R (82), and F5 (116)
        // Allow Ctrl+V specifically in input and textarea
        if (event.ctrlKey && event.keyCode === 86 && (event.target.tagName === "INPUT" || event.target.tagName === "TEXTAREA")) {
            return true;  // Allow Ctrl+V in input or textarea
        }

        // Block other Ctrl key combinations
        if (event.ctrlKey && ![67, 82, 86, 88, 90].includes(event.keyCode)) {
            return false; // Block other Ctrl combinations
        }

        // Allow F5 (Refresh)
        if (event.keyCode === 116) {
            return true;
        }
    };

    // Prevent right-click using the mouse (right-click button)
    document.onmousedown = function (event) {
        if (event.button === 2) { // Right-click is button 2
            return false;
        }
    };

</script>--}}
</body>
</html>
