@extends('main')
@section('h_title', 'All Offers')
@section('offer', 'active')
@section('body')
    @push('css_cdn')
        <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css"/>
        <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css"/>
        <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">
    @endpush
    <div class="row">

        <div class="col-xxl-6 col-lg-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">All Posts</h5>
                    <div class="col-lg-12">
                        <div class="tab-content text-muted mt-3">
                            <div class="tab-pane fade active show" id="custom-v-pills-bank-gateway" role="tabpanel"
                                 aria-labelledby="custom-v-pills-bank-gateway-tab">

                                <form method="POST" action="{{ route('admin.offers.store') }}"
                                      enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="col-lg-12">
                                                <div class="mb-3">
                                                    <label for="formFile" class="form-label">Post Title</label>
                                                    <input class="form-control" type="text" name="title"
                                                           id="title">
                                                    @error('title')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>

                                            </div>

                                            <div class="col-lg-12">
                                                <div class="mb-3">
                                                    <label for="formFile" class="form-label">Post URL</label>
                                                    <input class="form-control" type="url" name="url"
                                                           id="url">
                                                    @error('url')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="col-lg-12">
                                                <div class="mb-3">
                                                    <label for="formFile" class="form-label">Upload Thumbnail</label>
                                                    <input class="form-control" type="file" name="thumbnail"
                                                           id="formFile">
                                                    @error('thumbnail')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="col-lg-12">
                                                <div class="hstack gap-2 justify-content-end">
                                                    <button type="submit" class="btn btn-primary">Add</button>
                                                    <button type="button" class="btn btn-soft-success">Cancel</button>
                                                </div>
                                            </div>
                                            <!--end col-->
                                        </div>

                                    </div>

                                </form>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xxl-6 col-lg-6">
            <div class="col-md-12">
                <div class="card-header align-items-center d-flex">
                    <h4 class="card-title mb-0 flex-grow-1">Posts List</h4>
                </div><!-- end card header -->
                <div class="card-body">
                    <table class="table table-borderless table-nowrap">
                        <thead>
                        <tr>
                            <th scope="col">Id</th>
                            <th scope="col">Image</th>
                            <th scope="col">Title</th>
                            <th scope="col">Url</th>
                            <th scope="col">Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($offers as $item)
                            <tr>
                                <th scope="row">{{ $loop->iteration }}</th>
                                <td>
                                    <img src="{{ asset($item->image) }}" alt="banner" style="height: 50px"
                                         width="50px">
                                </td>
                                <td>
                                    {{ $item->title }}
                                </td>

                                <td>
                                    {{ $item->url }}
                                </td>
                                <td>
                                    <div class="hstack gap-3 fs-15">
                                        <a href="{{ route('admin.offers.delete', $item->id) }}"
                                           class="link-danger delete-item-btn"><i class="ri-delete-bin-5-line"></i></a>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

@endsection
@push('js_cdn')
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"
            integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="{{ asset('assets/js/pages/datatables.init.js')}}"></script>
@endpush
@push('js')
    <script>
        $(document).ready(function () {
            // Example: Show file names when files are selected
            $('input[type="file"]').on('change', function () {
                let fileName = $(this).val().split('\\').pop();
                $(this).next('.form-label').text(fileName);
            });
        });

        $(document).on("click", ".delete-item-btn", function (e) {
            e.preventDefault(); // Prevent default action
            var link = $(this).attr('href'); // Get the href attribute

            Swal.fire({
                title: "Are you sure?",
                text: "You can't restore the item",
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: "Yes, delete",
                cancelButtonText: "Cancel",
                buttonsStyling: false,
                customClass: {
                    confirmButton: 'btn btn-primary w-xs me-2 mt-2',
                    cancelButton: 'btn btn-danger w-xs mt-2'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire({
                        title: "Deleted!",
                        text: "Item has been deleted.",
                        icon: "success",
                        confirmButtonClass: "btn btn-primary w-xs mt-2",
                        buttonsStyling: false
                    }).then(() => {
                        window.location.href = link; // Redirect after showing success message
                    });
                }
            });
        });
    </script>
@endpush
