@extends('main')
@section('h_title', 'Promotion')
@section('promotion', 'active')
@section('body')
    <div class="row">

        <div class="col-lg-8">
            <div class="row">
               {{-- <div class="col-md-6">
                    <div class="card">
                        <div class="card-header align-items-center d-flex">
                            <h4 class="card-title mb-0 flex-grow-1">Slide Notice</h4>
                        </div><!-- end card header -->
                        <div class="card-body">
                            <form action="{{ route('admin.promotion.marquee') }}" method="POST">
                                @csrf
                                @method('PUT')
                                <textarea class="form-control" id="exampleFormControlTextarea5" rows="10"
                                          placeholder="Enter dashboard notice"
                                          name="notice">{{ $notice->notice_text }}</textarea>

                                @error('notice')
                                <span class="text-danger mt-2">{{ $message }}</span>
                                @enderror

                                <button class="btn btn-primary mt-3" type="submit">Update Notice</button>
                            </form>

                        </div>
                    </div>
                </div>--}}

                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header align-items-center d-flex">
                            <h4 class="card-title mb-0 flex-grow-1">Dashboard Notice</h4>
                        </div><!-- end card header -->
                        <div class="card-body">
                            <form action="{{ route('admin.promotion.notice') }}" method="POST">
                                @csrf
                                @method('PUT')
                                <!-- Example Textarea -->

                                <textarea class="form-control" id="exampleFormControlTextarea5" rows="10"
                                          placeholder="Enter dashboard notice"
                                          name="notice">{{ $dNotice->notice }}</textarea>

                                @error('notice')
                                <span class="text-danger mt-2">{{ $message }}</span>
                                @enderror

                                <button class="btn btn-primary mt-3" type="submit">Update Notice</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>

           {{-- <div class="row">
                <div class="col-md-6">
                    <div class="card">
                        <div class="card-header align-items-center d-flex">
                            <h4 class="card-title mb-0 flex-grow-1">Rate Notice</h4>
                        </div><!-- end card header -->
                        <div class="card-body">
                            <form action="{{ route('admin.promotion.rate.notice') }}" method="POST">
                                @csrf
                                @method('PUT')
                                <textarea class="form-control" id="exampleFormControlTextarea5" rows="10"
                                          placeholder="Enter Rate Notice"
                                          name="notice">{{ $dNotice->rate_notice }}</textarea>

                                @error('notice')
                                <span class="text-danger mt-2">{{ $message }}</span>
                                @enderror

                                <button class="btn btn-primary mt-3" type="submit">Update Notice</button>
                            </form>

                        </div>
                    </div>
                </div>

                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-header align-items-center d-flex">
                            <h4 class="card-title mb-0 flex-grow-1">Package Notice</h4>
                        </div><!-- end card header -->
                        <div class="card-body">
                            <form action="{{ route('admin.promotion.package.notice') }}" method="POST">
                                @csrf
                                @method('PUT')
                                <!-- Example Textarea -->

                                <textarea class="form-control" id="exampleFormControlTextarea5" rows="10"
                                          placeholder="Enter dashboard notice"
                                          name="notice">{{ $dNotice->package_notice }}</textarea>

                                @error('notice')
                                <span class="text-danger mt-2">{{ $message }}</span>
                                @enderror

                                <button class="btn btn-primary mt-3" type="submit">Update Notice</button>
                            </form>
                        </div>
                    </div>
                </div>
            </div>--}}

        </div>


        <div class="col-lg-4">
            <div class="card">
                <div class="card-header align-items-center d-flex">
                    <h4 class="card-title mb-0 flex-grow-1">Show Promotion Slide</h4>
                </div><!-- end card header -->
                <div class="card-body">

                    <!-- With Indicators -->
                    <div id="carouselExampleIndicators" class="carousel slide" data-bs-ride="carousel">
                        <div class="carousel-indicators">
                            <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="0"
                                    class="active" aria-current="true" aria-label="Slide 1"></button>
                            <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="1"
                                    aria-label="Slide 2"></button>
                            <button type="button" data-bs-target="#carouselExampleIndicators" data-bs-slide-to="2"
                                    aria-label="Slide 3"></button>
                        </div>
                        <div class="carousel-inner" role="listbox">
                            @foreach($banners as $index => $banner)
                                <div class="carousel-item {{ $loop->first ? 'active' : '' }}">
                                    <img class="d-block img-fluid mx-auto" src="{{ asset($banner->banner) }}"
                                         alt="banner">
                                </div>
                            @endforeach
                        </div>
                        <a class="carousel-control-prev" href="#carouselExampleIndicators" role="button"
                           data-bs-slide="prev">
                            <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                            <span class="sr-only">Previous</span>
                        </a>
                        <a class="carousel-control-next" href="#carouselExampleIndicators" role="button"
                           data-bs-slide="next">
                            <span class="carousel-control-next-icon" aria-hidden="true"></span>
                            <span class="sr-only">Next</span>
                        </a>
                    </div>

                </div>
            </div>
            <div class="card">
                <div class="card-header align-items-center d-flex">
                    <h4 class="card-title mb-0 flex-grow-1">Add Promotion Banner</h4>
                </div><!-- end card header -->
                <div class="card-body">
                    <form action="{{ route('admin.promotion.store') }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        <div>
                            <label for="formFile" class="form-label">Upload Banner <small
                                    class="text-danger">1024x500</small></label>
                            <input class="form-control" type="file" id="formFile" name="banner">
                        </div>

                        @error('banner')
                        <span class="text-danger mt-2">{{ $message }}</span>
                        @enderror

                        <button class="btn btn-primary mt-3" type="submit">Upload Banner</button>
                    </form>


                    <!-- Tables Without Borders -->
                    <table class="table table-borderless table-nowrap">
                        <thead>
                        <tr>
                            <th scope="col">Id</th>
                            <th scope="col">Image</th>
                            <th scope="col">Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($banners as $banner)
                            <tr>
                                <th scope="row">{{ $loop->iteration }}</th>
                                <td>
                                    <img src="{{ asset($banner->banner) }}" alt="banner" style="height: 50px"
                                         width="50px">
                                </td>
                                <td>
                                    <div class="hstack gap-3 fs-15">
                                        <a href="{{ route('admin.promotion.delete', $banner->id) }}"
                                           class="link-danger delete-item-btn"><i class="ri-delete-bin-5-line"></i></a>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>

                </div>
            </div>
        </div>
    </div>
@endsection
@push('js')
    <script>
        $(document).on("click", ".delete-item-btn", function (e) {
            e.preventDefault(); // Prevent default action
            var link = $(this).attr('href'); // Get the href attribute

            Swal.fire({
                title: "Are you sure?",
                text: "You can't restore the item",
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: "Yes, delete",
                cancelButtonText: "Cancel",
                buttonsStyling: false,
                customClass: {
                    confirmButton: 'btn btn-primary w-xs me-2 mt-2',
                    cancelButton: 'btn btn-danger w-xs mt-2'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire({
                        title: "Deleted!",
                        text: "Item has been deleted.",
                        icon: "success",
                        confirmButtonClass: "btn btn-primary w-xs mt-2",
                        buttonsStyling: false
                    }).then(() => {
                        window.location.href = link; // Redirect after showing success message
                    });
                }
            });
        });
    </script>
@endpush
