@extends('main')
@section('h_title', 'API Configuration')
@section('recharge_main', 'active')
@section('recharge_main_expand', 'true')
@section('recharge_show_main', 'show')
@section('recharge_show', 'show')
@section('auto_recharge', 'active')
@section('body')
    <div class="row">
        <div class="col-xxl-6 col-lg-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">API Recharge</h5>
                    <div class="col-lg-12">
                        <div class="tab-content text-muted mt-3">
                            <div class="tab-pane fade active show" id="custom-v-pills-bank-gateway" role="tabpanel"
                                 aria-labelledby="custom-v-pills-bank-gateway-tab">

                                <form method="POST" action="{{ route('admin.recharge.api.update') }}">
                                    @csrf
                                    @method('PUT')
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="col-lg-12">
                                                <div class="mb-3">
                                                    <label for="name" class="form-label">API Url</label>
                                                    <input type="text" class="form-control" id="api_url" name="api_url"
                                                           value="{{ $apiRecharge->api_url }}"
                                                           placeholder="API URL">
                                                    @error('api_url')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-lg-12">
                                                <div class="mb-3">
                                                    <label for="slug" class="form-label">API KEY</label>
                                                    <input type="text" class="form-control" id="api_key" name="api_key"
                                                           placeholder="API KEY" value="{{ $apiRecharge->api_key }}">
                                                    @error('api_key')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="col-lg-12">
                                                <div class="hstack gap-2 justify-content-end">
                                                    <button type="submit" class="btn btn-primary">Update</button>
                                                    <button type="button" class="btn btn-soft-success">Cancel</button>
                                                </div>
                                            </div>
                                            <!--end col-->
                                        </div>

                                    </div>

                                </form>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xxl-6 col-lg-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">API Balance</h5>
                    <div class="col-lg-12">
                        <div class="tab-content text-muted mt-3">
                            <div class="tab-pane fade active show" id="custom-v-pills-bank-gateway" role="tabpanel"
                                 aria-labelledby="custom-v-pills-bank-gateway-tab">
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="col-lg-12">
                                            <div class="mb-3">
                                                <label for="name" class="form-label">Balance</label>
                                                <input type="text" class="form-control" id="balance" name="balance"
                                                       value="{{ $balance . __(' BDT') }}" readonly>
                                                @error('api_url')
                                                <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection