@extends('main')
@section('h_title', 'Settings')
@section('body')
    <div class="position-relative mx-n4 mt-n4">
        <div class="profile-wid-bg profile-setting-img">
            <img src="{{ asset('assets/images/small/img-6.jpg') }}" class="profile-wid-img" alt="">
            <div class="overlay-content">
                <div class="text-end p-3">

                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-xxl-3">
            <div class="card mt-n5">
                <div class="card-body p-4">
                    <div class="text-center">
                        <div class="profile-user position-relative d-inline-block mx-auto  mb-4">
                            <img
                                src="{{ $dashboard->profile != null ? asset($dashboard->profile) : asset('assets/images/users/user-dummy-img.jpg') }}"
                                class="rounded-circle avatar-xl img-thumbnail user-profile-image"
                                alt="{{ $dashboard->username }}">
                        </div>
                        <h5 class="fs-16 mb-1">{{ $dashboard->name}}</h5>
                        <p class="text-muted mb-0">{{ $dashboard->role}}</p>
                    </div>
                </div>
            </div>
            <!--end card-->
        </div>
        <!--end col-->
        <div class="col-xxl-9">
            <div class="card mt-xxl-n5">
                <div class="card-header">
                    <ul class="nav nav-tabs-custom rounded card-header-tabs border-bottom-0" role="tablist">
                        <li class="nav-item">
                            <a class="nav-link active" data-bs-toggle="tab" href="#siteSettings" role="tab">
                                <i class="fas fa-home"></i> Site Settings
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" data-bs-toggle="tab" href="#license" role="tab">
                                <i class="far fa-user"></i> Configuration
                            </a>
                        </li>
                    </ul>
                </div>
                <div class="card-body p-4">
                    <div class="tab-content">
                        <div class="tab-pane active" id="siteSettings" role="tabpanel">
                            <form action="{{ route('admin.settings.update') }}" enctype="multipart/form-data"
                                  method="POST">
                                @csrf
                                @method('PUT')
                                <div class="row">
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="brandName" class="form-label">Brand Name</label>
                                            <input type="text" class="form-control" id="brandName" name="brandName"
                                                   placeholder="Enter your brand name"
                                                   value="{{ $settings->brandName}}">
                                            @error('brandName')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    <!--end col-->
                                    <div class="col-lg-6">
                                        <label for="favicon" class="form-label">Brand Favicon</label>
                                        <input class="form-control" id="favicon" type="file" name="brandFavIcon">
                                        @error('brandFavIcon')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <!--end col-->
                                    <div class="col-lg-6">
                                        <label for="brandLogo" class="form-label">Brand Logo</label>
                                        <input class="form-control" id="brandLogo" type="file" name="brandLogo">
                                        @error('brandLogo')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="app_url" class="form-label">Brand URL</label>
                                            <input type="text" class="form-control" id="app_url" name="app_url"
                                                   placeholder="Enter your app url" disabled>
                                            @error('app_url')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="terms_url" class="form-label">Terms & Condition Link</label>
                                            <input type="text" class="form-control" id="terms_url" name="terms_url"
                                                   placeholder="Enter your terms & condition url"
                                                   value="{{ $settings->terms_url}}">
                                            @error('terms_url')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    <div class="col-lg-6">
                                        <div class="mb-3">
                                            <label for="privacy_url" class="form-label">Privacy Policy Link</label>
                                            <input type="text" class="form-control" id="privacy_url" name="privacy_url"
                                                   placeholder="Enter your privacy policy url"
                                                   value="{{ $settings->privacy_url}}">
                                            @error('privacy_url')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>

                                    <!--end col-->
                                    <div class="col-lg-12 mt-4">
                                        <div class="hstack gap-2 justify-content-end">
                                            <button type="submit" class="btn btn-primary">Updates</button>
                                            <button type="button" class="btn btn-soft-success">Cancel</button>
                                        </div>
                                    </div>
                                    <!--end col-->
                                </div>
                                <!--end row-->
                            </form>
                        </div>
                        <!--end tab-pane-->
                        <div class="tab-pane" id="license" role="tabpanel">
                            <form action="javascript:void(0);">
                                <div class="row g-2">
                                    <div class="col-lg-6">
                                        <label for="packageName" class="form-label">Package Name</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" id="packageName"
                                                   value="{{ $config->packageName }}" disabled>
                                        </div>
                                    </div>
                                    <!--end col-->

                                    <div class="col-lg-6">
                                        <div class="input-group">
                                        </div>
                                    </div>
                                    <!--end col-->

                                    <!--end col-->
                                    <div class="col-lg-6">
                                        <label for="secret_key" class="form-label">Secret Key</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" id="secret_key"
                                                   value="{{ $config->secret_key }}" disabled>
                                            <button class="btn btn-primary" id="copySecretKey" type="button">Copy
                                            </button>
                                        </div>
                                    </div>
                                    <!--end col-->
                                    <div class="col-lg-6">
                                        <label for="app_secret" class="form-label">App Secret</label>
                                        <div class="input-group">
                                            <input type="text" class="form-control" id="app_secret"
                                                   value="{{ $config->app_secret }}" disabled>
                                            <button class="btn btn-primary" id="copyAppSecret" type="button">Copy
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <!--end row-->
                            </form>
                        </div>
                        <!--end tab-pane-->
                    </div>
                </div>
            </div>
        </div>
        <!--end col-->
    </div>
@endsection
@push('js')
    <script>
        // Function to copy text to clipboard
        function copyToClipboard(inputId) {
            // Get the input element by its ID
            var inputElement = document.getElementById(inputId);
            // Create a temporary input element to copy text
            var tempInput = document.createElement('input');
            tempInput.setAttribute('value', inputElement.value);
            document.body.appendChild(tempInput);
            tempInput.select();
            // Execute the copy command
            document.execCommand('copy');
            document.body.removeChild(tempInput);
            // Show the alert
            alert('Key copied to clipboard!');
        }

        // Event listener for Secret Key copy button
        document.getElementById('copySecretKey').addEventListener('click', function () {
            copyToClipboard('secret_key');
        });

        // Event listener for App Secret copy button
        document.getElementById('copyAppSecret').addEventListener('click', function () {
            copyToClipboard('app_secret');
        });
    </script>
@endpush
