@extends('main')
@section('h_title', 'Support Configure')
@section('support', 'active')
@section('body')

    <div class="row">

        <div class="col-xxl-12 col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Support Edit</h5>
                    <div class="col-lg-12">
                        <div class="tab-content text-muted mt-3">
                            <div class="tab-pane fade active show" id="custom-v-pills-bank-gateway" role="tabpanel"
                                 aria-labelledby="custom-v-pills-bank-gateway-tab">

                                <form method="POST" action="{{ route('admin.support.update') }}">
                                    @csrf
                                    @method('PUT')
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="col-lg-12">
                                                <div class="mb-3">
                                                <textarea class="ckeditor-classic"
                                                          placeholder="Enter about you or about your company"
                                                          name="about">{{ $support->about }}</textarea>
                                                </div>
                                            </div>

                                            <div class="col-lg-12">
                                                <div class="mb-3">
                                                    <label for="name" class="form-label">Messenger ID</label>
                                                    <input type="text" class="form-control" id="messenger_url"
                                                           name="messenger_url"
                                                           value="{{ $support->messenger }}"
                                                           placeholder="Enter your messenger id like: 1000078xxxxx">
                                                    @error('messenger_url')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-lg-12">
                                                <div class="mb-3">
                                                    <label for="slug" class="form-label">Telegram username</label>
                                                    <input type="text" class="form-control" id="tg_username"
                                                           name="tg_username"
                                                           placeholder="Enter your telegram username"
                                                           value="{{ $support->telegram }}">
                                                    @error('tg_username')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="col-lg-12">
                                                <div class="mb-3">
                                                    <label for="ac_holder" class="form-label">Whatsapp number</label>
                                                    <input type="text" class="form-control" id="whatsapp_number"
                                                           name="whatsapp_number"
                                                           value="{{ $support->whatsapp }}"
                                                           placeholder="Enter your whatsapp number">
                                                    @error('whatsapp_number')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>
                                            <!--end col-->
                                            <div class="col-lg-12">
                                                <div class="mb-3">
                                                    <label for="ac_number" class="form-label">Youtube Channel Link</label>
                                                    <input type="text" class="form-control" id="youtube_url"
                                                           name="youtube_url"
                                                           value="{{ $support->youtube }}"
                                                           placeholder="Enter your youtube channel id">
                                                    @error('youtube_url')
                                                    <span class="text-danger">{{ $message }}</span>
                                                    @enderror
                                                </div>
                                            </div>

                                            <div class="col-lg-12">
                                                <div class="hstack gap-2 justify-content-end">
                                                    <button type="submit" class="btn btn-primary">Update</button>
                                                    <button type="button" class="btn btn-soft-success">Cancel</button>
                                                </div>
                                            </div>
                                            <!--end col-->
                                        </div>

                                    </div>

                                </form>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection
@push('js_cdn')
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"
            integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <script src="{{ asset('assets/libs/@ckeditor/ckeditor5-build-classic/build/ckeditor.js') }}"></script>
    <script src="{{ asset('assets/js/pages/form-editor.init.js') }}"></script>
@endpush
