@extends('main')
@section('h_title', 'Sms  & Notification Configuration')
@section('body')
    <div class="row">
        <div class="col-xxl-4 col-lg-4">
            <!-- App Permission Card -->
            <div class="card mb-4">
                <div class="card-body">
                    <h5 class="card-title">App Permission</h5>
                    <div class="col-lg-12">
                        <div class="tab-content text-muted mt-3">
                            <div class="tab-pane fade active show">
                                <form method="POST" action="{{ route('admin.permissions.update') }}">
                                    @csrf
                                    @method('PUT')
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="mb-3">
                                                <label for="name" class="form-label">Permission Name</label>
                                                <input type="text" class="form-control" value="{{ $permission->name }}" placeholder="API URL" disabled>
                                            </div>

                                            <div class="mb-3">
                                                <select class="form-select mb-3" name="status">
                                                    <option selected disabled>Select Status</option>
                                                    <option value="active" {{ $permission->status == 'active'? 'selected': '' }}>Active</option>
                                                    <option value="inactive" {{ $permission->status == 'inactive'? 'selected': '' }}>Inactive</option>
                                                </select>
                                                @error('status')
                                                <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            <div class="hstack gap-2 justify-content-end">
                                                <button type="submit" class="btn btn-primary">Update</button>
                                                <button type="button" class="btn btn-soft-success">Cancel</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div> <!-- tab-pane -->
                        </div>
                    </div>
                </div>
            </div>

            <!-- OTP Configuration Card -->
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">OTP Configuration</h5>
                    <div class="col-lg-12">
                        <div class="tab-content text-muted mt-3">
                            <div class="tab-pane fade active show">
                                <form method="POST" action="{{ route('admin.sms-configuration.update') }}">
                                    @csrf
                                    @method('PUT')
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="mb-3">
                                                <label class="form-label">Service Name</label>
                                                <input type="text" class="form-control" value="{{ $apiSms->name }}" placeholder="API URL" disabled>
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">API KEY</label>
                                                <input type="text" class="form-control" name="api_key" placeholder="API KEY" value="{{ $apiSms->api_key }}">
                                                @error('api_key')
                                                <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">Sender ID</label>
                                                <input type="text" class="form-control" name="sender_id" value="{{ $apiSms->sender_id }}" placeholder="API username">
                                                @error('sender_id')
                                                <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>

                                            <div class="hstack gap-2 justify-content-end">
                                                <button type="submit" class="btn btn-primary">Update</button>
                                                <button type="button" class="btn btn-soft-success">Cancel</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div> <!-- tab-pane -->
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xxl-4 col-lg-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Firebase Json File</h5>

                    @if ($fileExists)
                        <h6>Current Credentials:</h6>
                        <pre>{{ $fileContents }}</pre>
                    @else
                        <p>No credentials file found.</p>
                    @endif

                    <div class="col-lg-12">
                        <div class="tab-content text-muted mt-3">
                            <div class="tab-pane fade active show" id="custom-v-pills-bank-gateway" role="tabpanel"
                                 aria-labelledby="custom-v-pills-bank-gateway-tab">

                                <form method="POST" action="{{ route('admin.update.json') }}"
                                      enctype="multipart/form-data">
                                    @csrf
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="mb-3">
                                                <label for="firebase_api_key" class="form-label">Firebase JSON </label>
                                                <input type="file" class="form-control" id="json_file" name="json_file"
                                                       accept=".json" required>
                                            </div>


                                            <div class="hstack gap-2 justify-content-end">
                                                <button type="submit" class="btn btn-primary">Upload</button>
                                                <button type="button" class="btn btn-soft-success">Cancel</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xxl-4 col-lg-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Notification Configuration</h5>
                    <div class="col-lg-12">
                        <div class="tab-content text-muted mt-3">
                            <div class="tab-pane fade active show" id="custom-v-pills-bank-gateway" role="tabpanel"
                                 aria-labelledby="custom-v-pills-bank-gateway-tab">

                                <form method="POST" action="{{ route('admin.update.firebase') }}">
                                    @csrf
                                    @method('PUT')
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="mb-3">
                                                <label for="firebase_api_key" class="form-label">Firebase API
                                                    Key</label>
                                                <input type="text" class="form-control" name="firebase_api_key"
                                                       value="{{ old('firebase_api_key', $firebaseApiKey ) }}"
                                                       placeholder="FIREBASE API KEY">
                                            </div>

                                            <div class="mb-3">
                                                <label for="firebase_auth_domain" class="form-label">Firebase Auth
                                                    Domain</label>
                                                <input type="text" class="form-control" name="firebase_auth_domain"
                                                       value="{{ old('firebase_auth_domain', $firebaseAuthDomain ) }}"
                                                       placeholder="FIREBASE AUTH DOMAIN">
                                            </div>

                                            <div class="mb-3">
                                                <label for="firebase_project_id" class="form-label">Firebase Project
                                                    ID</label>
                                                <input type="text" class="form-control" name="firebase_project_id"
                                                       value="{{ old('firebase_project_id', $firebaseProjectId ) }}"
                                                       placeholder="FIREBASE PROJECT ID">
                                            </div>

                                            <div class="mb-3">
                                                <label for="firebase_messaging_sender_id" class="form-label">Firebase
                                                    Messaging Sender ID</label>
                                                <input type="text" class="form-control"
                                                       name="firebase_messaging_sender_id"
                                                       value="{{ old('firebase_messaging_sender_id', $firebaseMessagingSenderId ) }}"
                                                       placeholder="FIREBASE MESSAGING SENDER ID">
                                            </div>

                                            <div class="mb-3">
                                                <label for="firebase_app_id" class="form-label">Firebase App ID</label>
                                                <input type="text" class="form-control" name="firebase_app_id"
                                                       value="{{ old('firebase_app_id', $firebaseAppId ) }}"
                                                       placeholder="FIREBASE APP ID">
                                            </div>

                                            <div class="mb-3">
                                                <label for="firebase_measurement_id" class="form-label">Firebase
                                                    Measurement ID</label>
                                                <input type="text" class="form-control" name="firebase_measurement_id"
                                                       value="{{ old('firebase_measurement_id', $firebaseMeasurementId ) }}"
                                                       placeholder="FIREBASE MEASUREMENT ID">
                                            </div>

                                            <div class="mb-3">
                                                <label for="firebase_measurement_id" class="form-label">Web Push
                                                    Certificate Key</label>
                                                <input type="text" class="form-control" name="firebase_vapi_key"
                                                       value="{{ old('firebase_vapi_key', $firebase_vapi_key ) }}"
                                                       placeholder="Web Push certificate key">
                                            </div>

                                            <div class="hstack gap-2 justify-content-end">
                                                <button type="submit" class="btn btn-primary">Update</button>
                                                <button type="button" class="btn btn-soft-success">Cancel</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
@endsection
