@extends('main')
@section('h_title', 'Transactions')
@push('css_cdn')
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css"/>
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css"/>
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">
@endpush
@section('body')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Transactions</h5>
                </div>
                <div class="card-body">
                    <table id="scroll-horizontal" class="table nowrap align-middle" style="width:100%">
                        <thead>
                        <tr>
                            <th scope="col" style="width: 10px;">
                                <div class="form-check">
                                    <input class="form-check-input fs-15" type="checkbox" id="checkAll" value="option">
                                </div>
                            </th>
                            <th data-ordering="false">#</th>
                            <th data-ordering="false">Name</th>
                            <th data-ordering="false">Receiver Account</th>
                            <th data-ordering="false">amount</th>
                            <th data-ordering="false">Status</th>
                            <th>Sending Time</th>
                            <th>Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($transactions as $data)
                            <tr>
                                <th scope="row">
                                    <div class="form-check">
                                        <input class="form-check-input fs-15" type="checkbox" name="checkAll"
                                               value="option1">
                                    </div>
                                </th>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $data->user != null ? $data->user->name : 'User not found'}}</td>
                                <td>{{ $data->ac_number }}</td>
                                <td>{{ $data->amount . __(" BDT") }}</td>
                                <td>
                                    <button class="btn btn-{{ $data->status == 'pending' ? 'warning status-btn' : ($data->status == 'accepted' ? 'success' : 'danger') }} waves-effect waves-light btn-sm"
                                            data-id="{{ $data->id }}">
                                        {{ $data->status == 'pending' ? 'Pending' : ($data->status == 'accepted' ? 'Accepted' : 'Rejected') }}
                                    </button>
                                </td>

                                <td>{{ \Carbon\Carbon::make($data->created_at)->format('D, d M Y') }}</td>
                                <td>
                                    <a href="{{ route('admin.transactions.delete', $data->id) }}"
                                       class="btn btn-outline-danger btn-icon waves-effect waves-light remove-item-btn"><i
                                            class="ri-delete-bin-line"></i></a>
                                </td>
                            </tr>
                        @endforeach

                        </tbody>
                    </table>
                </div>
            </div>
        </div><!--end col-->
    </div><!--end row-->

@endsection
@push('js_cdn')

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"
            integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

    <script src="{{ asset('assets/js/pages/datatables.init.js')}}"></script>
@endpush
@push('js')
    <script>
        $(document).on("click", ".remove-item-btn", function (e) {
            e.preventDefault(); // Prevent default action
            var link = $(this).attr('href'); // Get the href attribute

            Swal.fire({
                title: "Are you sure?",
                text: "You can't restore the item",
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: "Yes, delete",
                cancelButtonText: "Cancel",
                buttonsStyling: false,
                customClass: {
                    confirmButton: 'btn btn-primary w-xs me-2 mt-2',
                    cancelButton: 'btn btn-danger w-xs mt-2'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire({
                        title: "Deleted!",
                        text: "Item has been deleted.",
                        icon: "success",
                        confirmButtonClass: "btn btn-primary w-xs mt-2",
                        buttonsStyling: false
                    }).then(() => {
                        window.location.href = link; // Redirect after showing success message
                    });
                }
            });
        });

        $(document).on("click", ".status-btn", function () {
            var transactionId = $(this).data("id");

            Swal.fire({
                title: "Update Transaction Status",
                text: "Choose the new status for this transaction",
                icon: "warning",
                confirmButtonText: "Accept",
                showDenyButton: true,
                denyButtonText: "Cancel Transaction",
                buttonsStyling: false,
                customClass: {
                    confirmButton: "btn btn-success w-xs me-2 mt-2",
                    denyButton: "btn btn-warning w-xs mt-2"
                }
            }).then((result) => {
                let newStatus = "";

                if (result.isConfirmed) {
                    newStatus = "accepted";
                } else if (result.isDenied) {
                    newStatus = "rejected";
                }

                if (newStatus) {
                    $.ajax({
                        url: "{{ route('admin.transactions.update-status') }}",
                        type: "POST",
                        data: {
                            _token: "{{ csrf_token() }}",
                            transaction_id: transactionId,
                            status: newStatus
                        },
                        success: function (response) {
                            if (response.status) {
                                Swal.fire({
                                    title: "Success!",
                                    text: response.message,
                                    icon: "success",
                                    confirmButtonClass: "btn btn-primary w-xs mt-2",
                                    buttonsStyling: false
                                }).then(() => {
                                    location.reload();
                                });
                            } else {
                                Swal.fire({
                                    title: "Error!",
                                    text: response.message,
                                    icon: "error",
                                    confirmButtonClass: "btn btn-danger w-xs mt-2",
                                    buttonsStyling: false
                                });
                            }
                        }
                    });
                }
            });
        });

    </script>
@endpush

