@extends('main')
@section('h_title', 'Add user')
@section('users_add', 'active')
@section('users_main', 'active')
@section('users_show', 'show')
@section('users_expanded', 'true')
@section('body')
    <div class="col-xxl-12 col-lg-12">
        <div class="card">
            <div class="card-header align-items-center d-flex">
                <h4 class="card-title mb-0 flex-grow-1">ADD USER</h4>
            </div><!-- end card header -->
            <div class="card-body">
                <form method="POST" action="{{ route('admin.users.store') }}"
                      enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <div class="col-md-3 col-lg-3"></div>
                        <div class="col-lg-8 col-md-8 col-sm-12">
                            <div class="col-lg-10 ">
                                <div class="mb-3">
                                    <label for="name" class="form-label">Name</label>
                                    <input type="text" class="form-control" id="name" name="name"
                                           value="{{ old('name') }}"
                                           placeholder="Name">
                                    @error('name')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-10 ">
                                <div class="mb-3">
                                    <label for="name" class="form-label">Email</label>
                                    <input type="text" class="form-control" id="email" name="email"
                                           value="{{ old('email') }}"
                                           placeholder="Email">
                                    @error('email')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <!--end col-->

                            <div class="col-lg-10">
                                <div class="mb-3">
                                    <label for="number" class="form-label">Phone Number</label>
                                    <input type="number" class="form-control" id="number"
                                           name="number"
                                           value="{{ old('number') }}"
                                           placeholder="Phone number">
                                    @error('number')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-lg-10">
                                <div class="mb-3">
                                    <label for="pin" class="form-label">Pin</label>
                                    <input type="number" class="form-control" id="pin"
                                           name="pin"
                                           value="{{ old('pin') }}"
                                           placeholder="Pin min 4 digit">
                                    @error('pin')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <!--end col-->

                            <div class="col-lg-10">
                                <div class="mb-3">
                                    <label for="password" class="form-label">Password</label>
                                    <input type="text" class="form-control" id="password"
                                           name="password"
                                           value="{{ old('password') }}"
                                           placeholder="Minimum password 6 digits">
                                    @error('password')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <!--end col-->

                            <div class="col-lg-10">
                                <div class="form-check form-check-outline form-check-primary mb-3">
                                    <input class="form-check-input" type="checkbox" id="formCheck19"
                                           name="status"
                                           checked>
                                    <label class="form-check-label" for="formCheck19">
                                        Status
                                    </label>
                                </div>
                            </div>

                            <!--end col-->
                            <div class="col-lg-10">
                                <div class="hstack gap-2 justify-content-end">
                                    <button type="submit" class="btn btn-primary">Add</button>
                                    <button type="button" class="btn btn-soft-success">Cancel</button>
                                </div>
                            </div>
                            <!--end col-->

                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>
@endsection
