@extends('main')
@section('h_title')
    {{ __('Edit '). $user->name }}
@endsection
@section('users_view', 'active')
@section('users_main', 'active')
@section('users_show', 'show')
@section('users_expanded', 'true')
@section('body')
    <div class="row">
        <div class="col-xxl-12 col-lg-12">
            <div class="card">
                <div class="card-header align-items-center d-flex">
                    <h4 class="card-title mb-0 flex-grow-1">Edit <span class="text-danger">{{ $user->name }}</span></h4>
                </div><!-- end card header -->
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-4 col-md-4 col-sm-12">
                            <form method="POST" action="{{ route('admin.users.update', $user->id) }}"
                                  enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="col-lg-10 ">
                                    <div class="mb-3">
                                        <label for="name" class="form-label">Name</label>
                                        <input type="text" class="form-control" id="name" name="name"
                                               value="{{ $user->name }}"
                                               placeholder="Name">
                                        @error('name')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <!--end col-->

                                <div class="col-lg-10 ">
                                    <div class="mb-3">
                                        <label for="name" class="form-label">Email</label>
                                        <input type="text" class="form-control" id="email" name="email"
                                               value="{{ $user->email }}"
                                               placeholder="Email">
                                        @error('email')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <!--end col-->

                                <div class="col-lg-10">
                                    <div class="mb-3">
                                        <label for="number" class="form-label">Phone Number</label>
                                        <input type="number" class="form-control" id="number"
                                               name="number"
                                               value="{{ $user->phone }}"
                                               placeholder="Phone number">
                                        @error('number')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <!--end col-->

                                <div class="col-lg-10">
                                    <div class="mb-3">
                                        <label for="number" class="form-label">Pin</label>
                                        <input type="number" class="form-control" id="pin"
                                               name="pin"
                                               value="{{ $user->pin }}"
                                               placeholder="4 Digit Pin">
                                        @error('pin')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <!--end col-->


                                {{--   <div class="col-lg-10">
                                       <div class="mb-3">
                                           <label for="role" class="form-label">Select Role</label>
                                           <select id="role" class="form-select" name="role">
                                               <option selected disabled>Choose...</option>
                                               <option value="dgm" {{ $user->role == 'dgm' ? 'selected' : '' }}>DGM</option>
                                               <option value="user" {{ $user->role == 'user' ? 'selected' : '' }}>User</option>
                                               <option value="dealer" {{ $user->role == 'dealer' ? 'selected' : '' }}>Dealer
                                               </option>
                                               <option value="manager" {{ $user->role == 'manager' ? 'selected' : '' }}>
                                                   Manager
                                               </option>
                                               <option value="retailer" {{ $user->role == 'retailer' ? 'selected' : '' }}>
                                                   Retailer
                                               </option>
                                               <option value="subAdmin" {{ $user->role == 'subAdmin' ? 'selected' : '' }}>Sub
                                                   Admin
                                               </option>
                                           </select>

                                           @error('role')
                                           <span class="text-danger mt-2">{{ $message }}</span>
                                           @enderror
                                       </div>
                                   </div>
                                   <!--end col-->--}}

                                <div class="col-lg-10">
                                    <div class="form-check form-check-outline form-check-primary mb-3">
                                        <input class="form-check-input" type="checkbox" id="formCheck19"
                                               name="status"
                                            {{ $user->status == 'active' ? 'checked' : '' }}>
                                        <label
                                            class="form-check-label text-{{ $user->status == 'active' ? 'danger' : 'success' }}"
                                            for="formCheck19">
                                            Status
                                        </label>
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-10">
                                    <div class="hstack gap-2 justify-content-end">
                                        <button type="submit" class="btn btn-primary">Update</button>
                                        <button type="button" class="btn btn-soft-success">Cancel</button>
                                    </div>
                                </div>
                                <!--end col-->
                            </form>
                        </div>

                        {{-- Balance Column --}}
                        <div class="col-md-4 col-lg-4">
                            <form method="POST" action="{{ route('admin.users.balance.update', $user->id) }}"
                                  enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="col-lg-10 ">
                                    <div class="mb-3">
                                        <label for="balance" class="form-label">Current Balance</label>
                                        <input type="text" class="form-control text-danger"
                                               value="{{ $user->balance }} BDT" disabled>
                                    </div>
                                </div>
                                <!--end col-->

                                <div class="col-lg-10 ">
                                    <div class="mb-3">
                                        <label for="balance" class="form-label">Amount</label>
                                        <input type="number" class="form-control" id="balance" name="balance"
                                               placeholder="Enter amount" value="{{ old('balance') }}">
                                        @error('balance')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-10">
                                    <div class="mb-3">
                                        <label for="role" class="form-label">Select Balance</label>
                                        <select id="role" class="form-select" name="s_balance">
                                            <option selected disabled>Choose...</option>
                                            <option value="debit">Debit Amount</option>
                                            <option value="credit">Credit Amount</option>
                                        </select>

                                        @error('s_balance')
                                        <span class="text-danger mt-2">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-lg-10">
                                    <div class="hstack gap-2 justify-content-end">
                                        <button type="submit" class="btn btn-primary">Add Balance</button>
                                        <button type="button" class="btn btn-soft-success">Cancel</button>
                                    </div>
                                </div>
                                <!--end col-->
                            </form>
                        </div>
                        {{-- Password Column --}}
                        <div class="col-md-4 col-lg-4">
                            <form method="POST" action="{{ route('admin.users.password.update', $user->id) }}"
                                  enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                                <div class="col-lg-10 ">
                                    <div class="mb-3">
                                        <label for="new_password" class="form-label">New Pin</label>
                                        <input type="text" class="form-control" id="new_password" name="new_password"
                                               placeholder="New Password" value="{{ old('new_password') }}">
                                        @error('new_password')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-10">
                                    <div class="mb-3">
                                        <label for="confirm_password" class="form-label">Confirm Pin</label>
                                        <input type="text" class="form-control" id="confirm_password"
                                               name="confirm_password"
                                               placeholder="Confirm Password" value="{{ old('confirm_password') }}">
                                        @error('confirm_password')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                <div class="col-lg-10">
                                    <div class="hstack gap-2 justify-content-end">
                                        <button type="submit" class="btn btn-primary">Update</button>
                                        <button type="button" class="btn btn-soft-success">Cancel</button>
                                    </div>
                                </div>
                                <!--end col-->
                            </form>
                        </div>

                    </div>
                </div>
            </div>
        </div>

        <div class="col-xxl-12 col-lg-12">
            <div class="card">
                <div class="card-header align-items-center d-flex">
                    <h4 class="card-title mb-0 flex-grow-1">
                        Type: <span class="text-danger">{{ $user->document->type }}</span>
                    </h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-2">
                            <form method="POST" action="{{ route('admin.users.kyc.update', $user->id) }}"
                                  enctype="multipart/form-data">
                                @csrf
                                @method('PUT')
                            <div class="mb-3">
                                <label for="kyc_status" class="form-label">KYC {{ $user->document->status }} </label>
                                <select id="kyc_status" class="form-select" name="kyc_status">
                                    <option selected disabled>Choose...</option>
                                    <option value="Approved" {{ $user->document->status == 'Approved' ? 'selected' : '' }}>Approved</option>
                                    <option value="Rejected" {{ $user->document->status == 'Rejected' ? 'selected' : '' }}>Rejected</option>
                                </select>

                                @error('status')
                                <span class="text-danger mt-2">{{ $message }}</span>
                                @enderror
                            </div>
                                <div class="col-lg-12">
                                    <div class="hstack gap-2 justify-content-end">
                                        <button type="submit" class="btn btn-primary">Update</button>
                                        <button type="button" class="btn btn-soft-success">Cancel</button>
                                    </div>
                                </div>
                                <!--end col-->
                            </form>
                        </div>
                            {{-- Front Part --}}
                            <div class="col-md-4 m-4 text-center">
                                <h5>{{ $user->document->type . __(' Front Part') }}</h5>
                                <img src="{{ asset($user->document->document_one) }}"
                                     alt="{{ $user->document->type }}"
                                     class="img-fluid rounded shadow clickable-image"
                                     style="max-height: 250px; width: auto; cursor: pointer;"
                                     data-bs-toggle="modal" data-bs-target="#imageModal"
                                     data-img="{{ asset($user->document->document_one) }}" />
                            </div>
                            @if(!empty($user->document->type))
                                {{-- Back Part --}}
                                <div class="col-md-4 m-4 text-center">
                                    <h5>{{ $user->document->type . __(' Back Part') }}</h5>
                                    <img src="{{ asset($user->document->document_two) }}"
                                         alt="{{ $user->document->type }}"
                                         class="img-fluid rounded shadow clickable-image"
                                         style="max-height: 250px; width: auto; cursor: pointer;"
                                         data-bs-toggle="modal" data-bs-target="#imageModal"
                                         data-img="{{ asset($user->document->document_two) }}" />
                                </div>
                            @endif


                        </div>

                    </div>
                </div>
            </div>
        </div>



    </div>
    <!-- Modal for Image Preview -->
    <div class="modal fade" id="imageModal" tabindex="-1" aria-labelledby="imageModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-body text-center">
                    <img src="" id="modalImage" class="img-fluid w-100 rounded" alt="Preview">
                </div>
            </div>
        </div>
    </div>
@endsection
@push('js')
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const modalImage = document.getElementById('modalImage');
            document.querySelectorAll('.clickable-image').forEach(img => {
                img.addEventListener('click', function () {
                    const imgSrc = this.getAttribute('data-img');
                    modalImage.src = imgSrc;
                });
            });
        });
    </script>

@endpush
