@extends('main')
@section('h_title', 'All Videos')
@section('videos', 'active')
@section('body')
    @push('css_cdn')
        <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css"/>
        <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css"/>
        <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">
    @endpush
    <div class="row">

        <div class="col-xxl-12 col-lg-12">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Youtube Video</h5>
                    <div class="col-lg-12">
                        <div class="tab-content text-muted mt-3">
                            <div class="tab-pane fade active show" id="custom-v-pills-bank-gateway" role="tabpanel"
                                 aria-labelledby="custom-v-pills-bank-gateway-tab">
                                <form method="POST" action="{{ route('admin.videos.update') }}">
                                    @csrf
                                    @method('PUT')
                                    <div class="row">

                                        <div class="col-lg-6">
                                            <div class="mb-3">
                                                <label for="formFile" class="form-label">Registration Video
                                                    URL</label>
                                                <input class="form-control" type="url" name="reg_video"
                                                       value="{{ $videos->reg_video }}"
                                                       id="reg_video">
                                                @error('reg_video')
                                                <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="col-lg-6">
                                            <div class="mb-3">
                                                <label for="formFile" class="form-label">Tutorial Video
                                                    URL</label>
                                                <input class="form-control" type="url" name="recharge_video"
                                                       value="{{ $videos->recharge_video }}"
                                                       id="recharge_video">
                                                @error('recharge_video')
                                                <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="col-lg-6">
                                            <div class="mb-3">
                                                <label for="formFile" class="form-label">Send Money Video
                                                    URL</label>
                                                <input class="form-control" type="url" name="send_money_video"
                                                       value="{{ $videos->send_money_video }}"
                                                       id="send_money_video">
                                                @error('send_money_video')
                                                <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="col-lg-6">
                                            <div class="mb-3">
                                                <label for="formFile" class="form-label">PayBill Video
                                                    URL</label>
                                                <input class="form-control" type="url" name="pay_bill_video"
                                                       value="{{ $videos->pay_bill_video }}"
                                                       id="pay_bill_video">
                                                @error('pay_bill_video')
                                                <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>
                                        <div class="col-lg-6">
                                            <div class="mb-3">
                                                <label for="formFile" class="form-label">Add Money Video
                                                    URL</label>
                                                <input class="form-control" type="url" name="add_money_video"
                                                       value="{{ $videos->add_money_video }}"
                                                       id="add_money_video">
                                                @error('add_money_video')
                                                <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="col-lg-6">
                                            <div class="mb-3">
                                                <label for="formFile" class="form-label">Bank Transfer Video
                                                    URL</label>
                                                <input class="form-control" type="url" name="bank_transfer_video"
                                                       value="{{ $videos->bank_transfer_video }}"
                                                       id="bank_transfer_video">
                                                @error('bank_transfer_video')
                                                <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="col-lg-6">
                                            <div class="mb-3">
                                                <label for="formFile" class="form-label">Mobile Banking Video
                                                    URL</label>
                                                <input class="form-control" type="url" name="mobile_banking_video"
                                                       value="{{ $videos->mobile_banking_video }}"
                                                       id="mobile_banking_video">
                                                @error('mobile_banking_video')
                                                <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="col-lg-6">
                                            <div class="mb-3">
                                                <label for="formFile" class="form-label">Remittance Video
                                                    URL</label>
                                                <input class="form-control" type="url" name="remittance_video"
                                                       value="{{ $videos->remittance_video }}"
                                                       id="remittance_video">
                                                @error('remittance_video')
                                                <span class="text-danger">{{ $message }}</span>
                                                @enderror
                                            </div>
                                        </div>

                                        <div class="col-lg-12">
                                            <div class="hstack gap-2 justify-content-end">
                                                <button type="submit" class="btn btn-primary">Update</button>
                                                <button type="button" class="btn btn-soft-success">Cancel</button>
                                            </div>
                                        </div>

                                    </div>

                                </form>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>

@endsection
@push('js_cdn')
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"
            integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="{{ asset('assets/js/pages/datatables.init.js')}}"></script>
@endpush
@push('js')
    <script>
        $(document).ready(function () {
            // Example: Show file names when files are selected
            $('input[type="file"]').on('change', function () {
                let fileName = $(this).val().split('\\').pop();
                $(this).next('.form-label').text(fileName);
            });
        });

        $(document).on("click", ".delete-item-btn", function (e) {
            e.preventDefault(); // Prevent default action
            var link = $(this).attr('href'); // Get the href attribute

            Swal.fire({
                title: "Are you sure?",
                text: "You can't restore the item",
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: "Yes, delete",
                cancelButtonText: "Cancel",
                buttonsStyling: false,
                customClass: {
                    confirmButton: 'btn btn-primary w-xs me-2 mt-2',
                    cancelButton: 'btn btn-danger w-xs mt-2'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire({
                        title: "Deleted!",
                        text: "Item has been deleted.",
                        icon: "success",
                        confirmButtonClass: "btn btn-primary w-xs mt-2",
                        buttonsStyling: false
                    }).then(() => {
                        window.location.href = link; // Redirect after showing success message
                    });
                }
            });
        });
    </script>
@endpush
