@extends('main')
@section('h_title', 'About Section')
@section('about_app', 'active')
@section('web_main', 'active')
@section('web_show', 'show')
@section('web_expanded', 'true')
@section('body')
    <div class="col-xxl-12 col-lg-12">
        <div class="card">
            <div class="card-header align-items-center d-flex">
                <h4 class="card-title mb-0 flex-grow-1">Hero Section</h4>
            </div><!-- end card header -->
            <div class="card-body">
                <form method="POST" action="{{ route('admin.web-settings.update.about') }}"
                      enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="row">
                        <div class="col-lg-8 col-md-8 col-sm-12">
                            <div class="col-lg-12 ">
                                <div class="mb-3">
                                    <label for="short_title" class="form-label">Short Title</label>
                                    <input type="text" class="form-control" id="short_title" name="short_title"
                                           value="{{ old('short_title', $aboutSection->short_title) }}"
                                           placeholder="Enter short title">
                                    @error('short_title')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-12 ">
                                <div class="mb-3">
                                    <label for="title" class="form-label">Title</label>
                                    <input type="text" class="form-control" id="title" name="title"
                                           value="{{ old('title',$aboutSection->title) }}"
                                           placeholder="Enter title">
                                    @error('title')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <!--end col-->

                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label for="description" class="form-label">Short Description</label>
                                    <textarea name="description" rows="5" class="form-control"
                                              placeholder="Enter description">{{$aboutSection->description}}</textarea>
                                    @error('description')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label for="about_img" class="form-label">About Image 140x150</label>
                                    <input type="file" class="form-control" id="about_img"
                                           name="about_img">
                                    @error('about_img')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                    @if(!empty($aboutSection->about_img))
                                        <img src="{{ asset($aboutSection->about_img) }}" alt=""
                                             style="height: 20vh; margin-top: 10px">
                                    @endif
                                </div>

                            </div>
                            <!--end col-->

                            <!--end col-->
                            <div class="col-lg-10">
                                <div class="hstack gap-2 justify-content-end">
                                    <button type="submit" class="btn btn-primary">Update</button>
                                    <button type="button" class="btn btn-soft-success">Cancel</button>
                                </div>
                            </div>
                            <!--end col-->

                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>
@endsection
