@extends('main')
@section('h_title', 'Download')
@section('download', 'active')
@section('web_main', 'active')
@section('web_show', 'show')
@section('web_expanded', 'true')
@section('body')
    <div class="row">

        <div class="col-xxl-6 col-lg-6">
            <div class="card">
                <div class="card-header align-items-center d-flex">
                    <h4 class="card-title mb-0 flex-grow-1">Download Section</h4>
                </div><!-- end card header -->
                <div class="card-body">
                    <form method="POST" action="{{ route('admin.web-settings.update.video') }}"
                          enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12">
                                <div class="col-lg-12 ">
                                    <div class="mb-3">
                                        <label for="url" class="form-label">Youtube url</label>
                                        <input type="url" class="form-control" id="url" name="url"
                                               value="{{ old('url', $downloadSection->video_url) }}"
                                               placeholder="Enter youtube video url">
                                        @error('url')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-12">
                                    <div class="hstack gap-2 justify-content-end">
                                        <button type="submit" class="btn btn-primary">Update</button>
                                        <button type="button" class="btn btn-soft-success">Cancel</button>
                                    </div>
                                </div>
                                <!--end col-->

                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>
        <div class="col-md-6 col-lg-6 mb-3">
            <div class="card shadow-sm">
                <div class="card-header">
                    Upload APK
                </div>
                <div class="card-body">
                    @if ($errors->any())
                        <div>
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li class="text-danger">{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    @if (session('success'))
                        <div class="alert alert-success">
                            {{ session('success') }}
                        </div>
                    @elseif(session('error'))
                        <div class="alert alert-danger">
                            {{ session('error') }}
                        </div>
                    @endif

                    <div class="container">
                        @if($downloadSection)
                            <h5>App Name: {{ $downloadSection->app_name }}</h5>
                            <p><strong>File Name:</strong> {{ $downloadSection->app_name }}</p>
                            <p><strong>File Path:</strong> <a href="{{ route('apk.download') }}">Download APK</a></p>
                        @else
                            <p>No APK file uploaded yet.</p>
                        @endif
                        <h3>Upload APK File</h3>
                        <input type="file" id="apk_file" class="form-control my-3">
                        <div id="progress-bar" style="width: 100%; background-color: #eee;">
                            <div id="progress" style="width: 0%; height: 20px; background-color: #28a745;"></div>
                        </div>
                    </div>

                </div>
            </div>
        </div>

    </div>

@endsection
@push('js_cdn')
    <script src="https://cdn.jsdelivr.net/npm/resumablejs@1.1.0/resumable.min.js"></script>
    <script>
        const r = new Resumable({
            target: "{{ route('admin.web-settings.upload.apk') }}",
            query: {_token: '{{ csrf_token() }}'},
            fileType: ['apk'],
            chunkSize: 2 * 1024 * 1024, // 2MB
            testChunks: false,
            headers: {
                'Accept': 'application/json'
            }
        });

        r.assignBrowse(document.getElementById('apk_file'));

        r.on('fileAdded', function (file) {
            r.upload();
        });

        r.on('fileProgress', function (file) {
            let progress = Math.floor(file.progress() * 100);
            document.getElementById('progress').style.width = progress + '%';
        });

        r.on('fileSuccess', function (file, response) {
            alert('Upload complete');
        });

        r.on('fileError', function (file, message) {
            alert('Upload failed: ' + message);
        });
    </script>
@endpush
