@extends('main')
@section('h_title', 'Feature')
@section('features', 'active')
@section('web_main', 'active')
@section('web_show', 'show')
@section('web_expanded', 'true')
@section('body')
    <div class="col-xxl-12 col-lg-12">
        <div class="card">
            <div class="card-header align-items-center d-flex">
                <h4 class="card-title mb-0 flex-grow-1">Hero Section</h4>
            </div><!-- end card header -->
            <div class="card-body">
                <form method="POST" action="{{ route('admin.web-settings.update.feature') }}"
                      enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="row">
                        <div class="col-lg-12 col-md-12 col-sm-12">
                            <div class="col-lg-12 ">
                                <div class="mb-3">
                                    <label for="short_title" class="form-label">Short Title</label>
                                    <input type="text" class="form-control" id="short_title" name="short_title"
                                           value="{{ old('short_title', $featureSection->short_title) }}"
                                           placeholder="Enter short title">
                                    @error('short_title')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-12 ">
                                <div class="mb-3">
                                    <label for="title" class="form-label">Title</label>
                                    <input type="text" class="form-control" id="title" name="title"
                                           value="{{ old('title',$featureSection->title) }}"
                                           placeholder="Enter title">
                                    @error('title')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <!--end col-->

                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label for="description" class="form-label">Short Description</label>
                                    <textarea name="description" rows="5" class="form-control"
                                              placeholder="Enter short description">{{$featureSection->description}}</textarea>
                                    @error('description')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label for="f_image" class="form-label">Screenshot 375x595</label>
                                    <input type="file" class="form-control" id="f_image"
                                           name="f_image">
                                    @error('f_image')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                    @if(!empty($featureSection->f_image))
                                        <img src="{{ asset($featureSection->f_image) }}" alt=""
                                             style="margin-top: 10px; background: purple;">
                                    @endif
                                </div>

                            </div>
                            <!--end col-->
                            <hr>

                            <div class="row">
                                <div class="col-md-4">
                                    <div class="col-lg-12 ">
                                        <div class="mb-3">
                                            <label for="t_one" class="form-label">Title One</label>
                                            <input type="text" class="form-control" id="t_one" name="t_one"
                                                   value="{{ old('t_one',$featureSection->t_one) }}"
                                                   placeholder="Enter title">
                                            @error('t_one')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    <!--end col-->

                                    <div class="col-lg-12">
                                        <div class="mb-3">
                                            <label for="d_one" class="form-label">Short Description</label>
                                            <textarea name="d_one" rows="5" class="form-control"
                                                      placeholder="Enter short description">{{$featureSection->d_one}}</textarea>
                                            @error('d_one')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="col-lg-12 ">
                                        <div class="mb-3">
                                            <label for="t_two" class="form-label">Title two</label>
                                            <input type="text" class="form-control" id="t_two" name="t_two"
                                                   value="{{ old('t_two',$featureSection->t_two) }}"
                                                   placeholder="Enter title">
                                            @error('t_two')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    <!--end col-->

                                    <div class="col-lg-12">
                                        <div class="mb-3">
                                            <label for="d_two" class="form-label">Short Description</label>
                                            <textarea name="d_two" rows="5" class="form-control"
                                                      placeholder="Enter short description">{{$featureSection->d_two}}</textarea>
                                            @error('d_two')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="col-lg-12 ">
                                        <div class="mb-3">
                                            <label for="t_three" class="form-label">Title three</label>
                                            <input type="text" class="form-control" id="t_three" name="t_three"
                                                   value="{{ old('t_three',$featureSection->t_three) }}"
                                                   placeholder="Enter title">
                                            @error('t_three')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    <!--end col-->

                                    <div class="col-lg-12">
                                        <div class="mb-3">
                                            <label for="d_three" class="form-label">Short Description</label>
                                            <textarea name="d_three" rows="5" class="form-control"
                                                      placeholder="Enter short description">{{$featureSection->d_three}}</textarea>
                                            @error('d_three')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="col-lg-12 ">
                                        <div class="mb-3">
                                            <label for="t_four" class="form-label">Title four</label>
                                            <input type="text" class="form-control" id="t_four" name="t_four"
                                                   value="{{ old('t_four',$featureSection->t_four) }}"
                                                   placeholder="Enter title">
                                            @error('t_four')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    <!--end col-->

                                    <div class="col-lg-12">
                                        <div class="mb-3">
                                            <label for="d_four" class="form-label">Short Description</label>
                                            <textarea name="d_four" rows="5" class="form-control"
                                                      placeholder="Enter short description">{{$featureSection->d_four}}</textarea>
                                            @error('d_four')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="col-lg-12 ">
                                        <div class="mb-3">
                                            <label for="t_five" class="form-label">Title five</label>
                                            <input type="text" class="form-control" id="t_five" name="t_five"
                                                   value="{{ old('t_five',$featureSection->t_five) }}"
                                                   placeholder="Enter title">
                                            @error('t_five')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    <!--end col-->

                                    <div class="col-lg-12">
                                        <div class="mb-3">
                                            <label for="d_five" class="form-label">Short Description</label>
                                            <textarea name="d_five" rows="5" class="form-control"
                                                      placeholder="Enter short description">{{$featureSection->d_five}}</textarea>
                                            @error('d_five')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="col-lg-12 ">
                                        <div class="mb-3">
                                            <label for="t_six" class="form-label">Title six</label>
                                            <input type="text" class="form-control" id="t_six" name="t_six"
                                                   value="{{ old('t_six',$featureSection->t_six) }}"
                                                   placeholder="Enter title">
                                            @error('t_six')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                    <!--end col-->

                                    <div class="col-lg-12">
                                        <div class="mb-3">
                                            <label for="d_six" class="form-label">Short Description</label>
                                            <textarea name="d_six" rows="5" class="form-control"
                                                      placeholder="Enter short description">{{$featureSection->d_six}}</textarea>
                                            @error('d_six')
                                            <span class="text-danger">{{ $message }}</span>
                                            @enderror
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="col-lg-10">
                                <div class="hstack gap-2 justify-content-end">
                                    <button type="submit" class="btn btn-primary">Update</button>
                                    <button type="button" class="btn btn-soft-success">Cancel</button>
                                </div>
                            </div>
                            <!--end col-->

                        </div>

                    </div>

                </form>
            </div>
        </div>
    </div>

@endsection
