@extends('main')
@section('h_title', 'Hero Section')
@section('web_hero', 'active')
@section('web_main', 'active')
@section('web_show', 'show')
@section('web_expanded', 'true')
@section('body')
    <div class="col-xxl-12 col-lg-12">
        <div class="card">
            <div class="card-header align-items-center d-flex">
                <h4 class="card-title mb-0 flex-grow-1">Hero Section</h4>
            </div><!-- end card header -->
            <div class="card-body">
                <form method="POST" action="{{ route('admin.web-settings.update.hero') }}"
                      enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="row">
                        <div class="col-lg-8 col-md-8 col-sm-12">
                            <div class="col-lg-12 ">
                                <div class="mb-3">
                                    <label for="short_title" class="form-label">Short Title</label>
                                    <input type="text" class="form-control" id="short_title" name="short_title"
                                           value="{{ old('short_title', $headerSection->short_title) }}"
                                           placeholder="Enter short title">
                                    @error('short_title')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-12 ">
                                <div class="mb-3">
                                    <label for="title" class="form-label">Title</label>
                                    <input type="text" class="form-control" id="title" name="title"
                                           value="{{ old('title',$headerSection->title) }}"
                                           placeholder="Enter title">
                                    @error('title')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <!--end col-->

                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label for="short_description" class="form-label">Short Description</label>
                                    <textarea name="short_description" rows="5" class="form-control"
                                              placeholder="Enter short description">{{$headerSection->short_description}}</textarea>
                                    @error('short_description')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>

                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label for="logo" class="form-label">Logo 161x45</label>
                                    <input type="file" class="form-control" id="logo"
                                           name="logo">
                                    @error('logo')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                    @if(!empty($headerSection->logo))
                                        <img src="{{ asset($headerSection->logo) }}" alt=""
                                             style="margin-top: 10px; background: purple;">
                                    @endif
                                </div>

                            </div>
                            <!--end col-->

                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label for="h_image" class="form-label">Header Screenshot 850x1126</label>
                                    <input type="file" class="form-control" id="h_image"
                                           name="h_image">
                                    @error('h_image')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                    @if(!empty($headerSection->h_screenshot))
                                        <img src="{{ asset($headerSection->h_screenshot) }}" alt=""
                                             style="height: 20vh; margin-top: 10px">
                                    @endif
                                </div>

                            </div>
                            <!--end col-->

                            <div class="col-lg-12">
                                <div class="mb-3">
                                    <label for="h_bg_image" class="form-label">Header Background Image 1920x1080</label>
                                    <input type="file" class="form-control" id="h_bg_image"
                                           name="h_bg_image">
                                    @error('h_bg_image')
                                    <span class="text-danger">{{ $message }}</span>
                                    @enderror
                                    @if(!empty($headerSection->h_bg_image))
                                        <img src="{{ asset($headerSection->h_bg_image) }}" alt=""
                                             style="height: 20vh; margin-top: 10px">
                                    @endif
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-lg-3">
                                    <div class="mb-3">
                                        <label for="t_client" class="form-label">Happy Client</label>
                                        <input type="text" class="form-control" id="t_client" name="t_client"
                                               value="{{ old('t_client',$headerSection->total_clients) }}"
                                               placeholder="Enter total client">
                                        @error('t_client')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div> <div class="col-lg-3">
                                    <div class="mb-3">
                                        <label for="t_download" class="form-label">App Download</label>
                                        <input type="text" class="form-control" id="t_download" name="t_download"
                                               value="{{ old('t_download',$headerSection->total_download) }}"
                                               placeholder="Enter total download">
                                        @error('t_download')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div> <div class="col-lg-3">
                                    <div class="mb-3">
                                        <label for="t_rates" class="form-label">Total Rates</label>
                                        <input type="text" class="form-control" id="t_rates" name="t_rates"
                                               value="{{ old('t_rates',$headerSection->total_rates) }}"
                                               placeholder="Enter total rates">
                                        @error('t_rates')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div> <div class="col-lg-3">
                                    <div class="mb-3">
                                        <label for="t_win" class="form-label">Awards Win</label>
                                        <input type="text" class="form-control" id="t_win" name="t_win"
                                               value="{{ old('t_win',$headerSection->total_awards) }}"
                                               placeholder="Enter total awards">
                                        @error('t_win')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <!--end col-->
                            <div class="col-lg-10">
                                <div class="hstack gap-2 justify-content-end">
                                    <button type="submit" class="btn btn-primary">Update</button>
                                    <button type="button" class="btn btn-soft-success">Cancel</button>
                                </div>
                            </div>
                            <!--end col-->

                        </div>
                    </div>

                </form>
            </div>
        </div>
    </div>
@endsection
