@extends('main')
@section('h_title', 'Screenshot')
@section('screenshot', 'active')
@section('web_main', 'active')
@section('web_show', 'show')
@section('web_expanded', 'true')
@push('css')
    <style>
        #imagePreview {
            display: flex;
            flex-wrap: wrap;
            gap: 10px; /* Adjust the gap between images */
        }

        .image-preview-item {
            position: relative;
            flex: 0 0 calc(20% - 10px); /* Adjust width of each item (20% means 5 items per row) */
            margin-bottom: 10px;
        }

        .image-preview-item img {
            width: 100%;
            height: auto;
            display: block;
        }

        .delete-overlay {
            position: absolute;
            top: 0;
            right: 0;
            bottom: 0;
            left: 0;
            background-color: rgba(0, 0, 0, 0.5);
            display: none;
            justify-content: center;
            align-items: center;
        }

        .image-preview-item:hover .delete-overlay {
            display: flex;
        }

        .delete-icon {
            color: white;
            font-size: 20px;
            cursor: pointer;
        }
    </style>

@endpush
@section('body')
    <div class="row">

        <div class="col-xxl-6 col-lg-6">
            <div class="card">
                <div class="card-header align-items-center d-flex">
                    <h4 class="card-title mb-0 flex-grow-1">Screenshot Section</h4>
                </div><!-- end card header -->
                <div class="card-body">
                    <form method="POST" action="{{ route('admin.web-settings.screenshots.update') }}"
                          enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-lg-12 col-md-12 col-sm-12">
                                <div class="col-lg-12 ">
                                    <div class="mb-3">
                                        <label for="short_title" class="form-label">Short Title</label>
                                        <input type="text" class="form-control" id="short_title" name="short_title"
                                               value="{{ old('short_title', $ssSection->short_title) }}"
                                               placeholder="Enter short title">
                                        @error('short_title')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <!--end col-->
                                <div class="col-lg-12 ">
                                    <div class="mb-3">
                                        <label for="title" class="form-label">Title</label>
                                        <input type="text" class="form-control" id="title" name="title"
                                               value="{{ old('title',$ssSection->title) }}"
                                               placeholder="Enter title">
                                        @error('title')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>
                                <!--end col-->

                                <div class="col-lg-12">
                                    <div class="mb-3">
                                        <label for="description" class="form-label">Short Description</label>
                                        <textarea name="description" rows="5" class="form-control"
                                                  placeholder="Enter description">{{$ssSection->description}}</textarea>
                                        @error('description')
                                        <span class="text-danger">{{ $message }}</span>
                                        @enderror
                                    </div>
                                </div>

                                <!--end col-->
                                <div class="col-lg-12">
                                    <div class="hstack gap-2 justify-content-end">
                                        <button type="submit" class="btn btn-primary">Update</button>
                                        <button type="button" class="btn btn-soft-success">Cancel</button>
                                    </div>
                                </div>
                                <!--end col-->

                            </div>
                        </div>

                    </form>
                </div>
            </div>
        </div>

        <div class="col-xxl-6 col-lg-6">
            <div class="card">
                <div class="card-header align-items-center d-flex">
                    <h4 class="card-title mb-0 flex-grow-1">Upload</h4>
                </div><!-- end card header -->
                <div class="card-body">
                    @if ($errors->any())
                        <div>
                            <ul>
                                @foreach ($errors->all() as $error)
                                    <li class="text-danger">{{ $error }}</li>
                                @endforeach
                            </ul>
                        </div>
                    @endif

                    <form class="forms-sample" action="{{ route('admin.web-settings.upload.screenshot') }}"
                          method="POST" enctype="multipart/form-data">
                        @csrf
                        <div class="col-lg-12">
                            <div class="mb-3">
                                <label for="images" class="form-label">Screenshot 540x1200</label>
                                <input type="file" class="form-control" id="images"
                                       name="images">
                                @error('images')
                                <span class="text-danger">{{ $message }}</span>
                                @enderror
                            </div>

                        </div>
                        <!--end col-->

                        <button type="submit" class="btn btn-primary mr-2">Upload</button>
                    </form>
                </div>
            </div>
        </div>

    </div>
@endsection
