<?php

use App\Http\Controllers\Admin\LiveChatController;
use App\Http\Controllers\Admin\LoanController;
use App\Http\Controllers\Admin\RechargeController;
use App\Http\Controllers\Api\AddMoneyController;
use App\Http\Controllers\Api\AuthController;
use App\Http\Controllers\Api\DashboardController;
use App\Http\Controllers\Api\OperatorController;
use App\Http\Controllers\GroupChatController;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "api" middleware group. Make something great!
|
*/

Route::post('check-number', [AuthController::class, 'checkNumber']);
Route::get('get-otp', [AuthController::class, 'getOtp']);
Route::post('verify-number', [AuthController::class, 'verifyPhoneNumber']);
Route::post('register', [AuthController::class, 'register']);
Route::post('login', [AuthController::class, 'login']);
Route::get('config', [AuthController::class, 'config']);
Route::post('send-otp', [AuthController::class, 'sendOtp']);
Route::post('verify-otp', [AuthController::class, 'verifyOtp']);
Route::post('change-password', [AuthController::class, 'changePassword']);
Route::get('video', [AuthController::class, 'video']);
 Route::get('packages', [OperatorController::class, 'packages']);
    Route::post('purchase-drive', [OperatorController::class, 'purchaseDrive']);

Route::middleware(['auth:sanctum'])->group(function () {
    Route::put('token', [AuthController::class, 'token']);
    Route::get('logout', [AuthController::class, 'logout']);
    Route::get('account-info', [AuthController::class, 'accountInfo']);
    Route::post('pin', [AuthController::class, 'pin']);
    Route::get('info', [DashboardController::class, 'infos']);
    Route::get('all-banks', [DashboardController::class, 'allBank']);
    Route::get('remittance-banks', [DashboardController::class, 'remittanceBank']);
    Route::get('global-operator', [DashboardController::class, 'globalOperator']);
    Route::get('bill-providers', [DashboardController::class, 'billProvider']);
    Route::get('profile', [DashboardController::class, 'profile']);
    Route::post('update-profile', [DashboardController::class, 'updateProfile']);
    Route::post('update-password', [DashboardController::class, 'updatePassword']);
    Route::post('update-pin', [DashboardController::class, 'updatePin']);

    Route::get('packages', [OperatorController::class, 'packages']);
    Route::post('purchase-drive', [OperatorController::class, 'purchaseDrive']);
    Route::post('remittance', [OperatorController::class, 'remittance']);
    Route::post('send-money', [OperatorController::class, 'sendMoney']);
    Route::post('mbanking-request', [OperatorController::class, 'mbankingRequest']);
    Route::post('bank-transfer', [OperatorController::class, 'bankTransfer']);
    Route::post('bill-payment', [OperatorController::class, 'billPayment']);
    Route::post('recharge-request', [OperatorController::class, 'rechargeRequest']);
    Route::get('auto-addmoney-key', [AddMoneyController::class, 'autoAddMoneyKey']);
    Route::get('mobile-addmoney', [AddMoneyController::class, 'mobileAddMoney']);
    Route::get('bank-addmoney', [AddMoneyController::class, 'bankAddMoney']);
    Route::post('auto-addmoney', [AddMoneyController::class, 'autoAddMoney']);
    Route::post('bank-deposit', [AddMoneyController::class, 'bankDeposit']);
    Route::post('m-deposit', [AddMoneyController::class, 'mobileDeposit']);
    Route::post('create-account', [AuthController::class, 'createAccount']);

    Route::get('get-accounts', [AuthController::class, 'getAccounts']);
    Route::get('history', [DashboardController::class, 'history']);
    Route::get('support', [DashboardController::class, 'support']);
    Route::get('company', [DashboardController::class, 'company']);
    Route::get('extras', [DashboardController::class, 'extras']);

    Route::get('admins', [DashboardController::class, 'admins']);
    Route::get('chats/{userId}', [LiveChatController::class, 'getMessages']);
    Route::post('message-send', [LiveChatController::class, 'sendMessage']);

});
