<?php

use App\Http\Controllers\InstallerController;
use Illuminate\Support\Facades\Route;

Route::group(['prefix' => 'installer', 'as' => 'installer.'], function () {
    Route::get('/', [InstallerController::class, 'requirements'])->name('requirements');
    Route::get('/update-requirements', [InstallerController::class, 'updateRequirements'])->name('update-requirements');
    Route::get('database', [InstallerController::class, 'database'])->name('database');
    Route::post('install', [InstallerController::class, 'install'])->name('install');
    Route::get('import', [InstallerController::class, 'import'])->name('import');
    Route::get('db-download', [InstallerController::class, 'dbDownload'])->name('db-download');
    Route::get('db-import', [InstallerController::class, 'dbImport'])->name('db-import');
    Route::get('skip-to-finish', [InstallerController::class, 'skipToFinish'])->name('skip');
    Route::get('finished', [InstallerController::class, 'finished'])->name('finished');
    Route::post('installation-finished', [InstallerController::class, 'installationFinished'])->name('installation-finished');
});
