<?php

use App\Http\Controllers\Admin\BankingController;
use App\Http\Controllers\Admin\BillController;
use App\Http\Controllers\Admin\Commission;
use App\Http\Controllers\UserPaymentController;
use App\Http\Controllers\Admin\DashboardController;
use App\Http\Controllers\Admin\FrontendController;
use App\Http\Controllers\Admin\GatewayController;
use App\Http\Controllers\Admin\LiveChatController;
use App\Http\Controllers\Admin\mBankingController;
use App\Http\Controllers\Admin\PackageController;
use App\Http\Controllers\Admin\OrderController;
use App\Http\Controllers\Admin\RechargeController;
use App\Http\Controllers\Admin\RemittanceController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Auth\ResetPasswordController;
use App\Http\Controllers\FcmController;
use App\Http\Controllers\Frontend\FrontendController as Frontend;
use App\Http\Controllers\User\UserDashController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Artisan;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/clear-all', function () {
    try {
        Artisan::call('optimize:clear');
        $notification = [
            'message' => 'All caches cleared',
            'alert-type' => 'success'
        ];
        return redirect()->back()->with($notification);
    } catch (\Exception $e) {
        // Log the error
        $notification = [
            'message' => 'An error occurred while clearing caches. Please try again later.',
            'alert-type' => 'error'
        ];
        return redirect()->back()->with($notification);
    }
})->name('cache_clear');

Route::middleware(['check.installation'])->group(function () {

    Route::get('/', [Frontend::class, 'index'])->name('index');
    Route::get('download-apk', [FrontendController::class, 'downloadApk'])->name('apk.download');

    Route::get('/forgot-password', [ResetPasswordController::class, 'showForgotForm'])->name('forgot');
    Route::post('send-otp', [ResetPasswordController::class, 'sendOtp'])->name('send.otp');
    Route::post('verify-otp', [ResetPasswordController::class, 'verifyOtp'])->name('verify.otp');
    Route::post('reset-password', [ResetPasswordController::class, 'changePassword'])->name('reset.password');


    require __DIR__ . '/auth.php';
    Route::group(['prefix' => 'admin', 'as' => 'admin.', 'middleware' => ['auth', 'role:admin']], function () {
        Route::get('/', [DashboardController::class, 'index'])->name('dashboard');
        Route::get('commissions', [DashboardController::class, 'commissionIndex'])->name('commissions.index');
        Route::put('update-commission/{id}', [DashboardController::class, 'updateCommission'])->name('commissions.update');
        Route::put('update-fee/{id}', [DashboardController::class, 'updateFees'])->name('fees.update');


        Route::put('update-token', [FcmController::class, 'updateToken'])->name('update.token');
        Route::put('update-firebase', [FcmController::class, 'updateFirebase'])->name('update.firebase');
        Route::post('upload-json', [FcmController::class, 'uploadJson'])->name('update.json');

        Route::group(['as' => 'notification.', 'prefix' => 'notification'], function () {
            Route::get('/', [FcmController::class, 'index'])->name('index');
            Route::post('send-notification', [FcmController::class, 'sendAllDeviceNotification'])->name('send');
        });

        Route::group(['prefix' => 'users', 'as' => 'users.'], function () {
            Route::get('/', [UserController::class, 'index'])->name('index');
            Route::get('add-user', [UserController::class, 'addUser'])->name('add');
            Route::post('store-user', [UserController::class, 'storeUser'])->name('store');
            Route::get('edit-user/{id}', [UserController::class, 'editUser'])->name('edit');
            Route::put('update-user/{id}', [UserController::class, 'updateUser'])->name('update');
            Route::put('update-password/{id}', [UserController::class, 'updatePassword'])->name('password.update');
            Route::put('update-balance/{id}', [UserController::class, 'updateBalance'])->name('balance.update');
            Route::put('kyc-update/{id}', [UserController::class, 'kycUpdate'])->name('kyc.update');

            Route::get('delete-user/{id}', [UserController::class, 'deleteUser'])->name('delete');
        });

        Route::group(['prefix' => 'profile', 'as' => 'profile.'], function () {
            Route::get('/', [DashboardController::class, 'profileIndex'])->name('index');
            Route::put('update', [DashboardController::class, 'updateProfile'])->name('update');
            Route::put('update-password', [DashboardController::class, 'updatePassword'])->name('update.password');
        });

        Route::group(['prefix' => 'permissions', 'as' => 'permissions.'], function () {
            Route::put('update', [DashboardController::class, 'updatePermission'])->name('update');
        });

        Route::group(['prefix' => 'sms-configuration', 'as' => 'sms-configuration.'], function () {
            Route::get('/', [DashboardController::class, 'smsIndex'])->name('index');
            Route::put('update', [DashboardController::class, 'updateSms'])->name('update');
        });

        Route::group(['prefix' => 'settings', 'as' => 'settings.'], function () {
            Route::get('/', [DashboardController::class, 'settingsIndex'])->name('index');
            Route::put('update', [DashboardController::class, 'updateBrand'])->name('update');
        });

        Route::group(['prefix' => 'support', 'as' => 'support.'], function () {
            Route::get('/', [DashboardController::class, 'supportIndex'])->name('index');
            Route::put('update', [DashboardController::class, 'updateSupport'])->name('update');
            Route::put('extra-update', [DashboardController::class, 'updateExtra'])->name('extra.update');

        });

        Route::group(['prefix' => 'transactions', 'as' => 'transactions.'], function () {
            Route::get('/', [DashboardController::class, 'transactionsIndex'])->name('index');
            Route::get('delete/{id}', [DashboardController::class, 'transactionsDelete'])->name('delete');
            Route::post('update-status', [DashboardController::class, 'transactionsUpdate'])->name('update-status');
        });

        Route::group(['prefix' => 'promotions', 'as' => 'promotion.'], function () {
            Route::get('/', [DashboardController::class, 'promotionIndex'])->name('index');
            Route::post('store', [DashboardController::class, 'storePromotion'])->name('store');
            Route::get('delete/{id}', [DashboardController::class, 'promotionDelete'])->name('delete');
            Route::put('marquee', [DashboardController::class, 'promotionMarquee'])->name('marquee');
            Route::put('dashboard-notice', [DashboardController::class, 'dashboardNotice'])->name('notice');
            Route::put('package-notice', [DashboardController::class, 'packageNotice'])->name('package.notice');
            Route::put('rate-notice', [DashboardController::class, 'rateNotice'])->name('rate.notice');
        });

        Route::group(['prefix' => 'recharge', 'as' => 'recharge.'], function () {
            Route::get('api-recharge', [RechargeController::class, 'apiIndex'])->name('api.index');
            Route::put('api-recharge-update', [RechargeController::class, 'apiUpdate'])->name('api.update');
            Route::get('pending', [OrderController::class, 'pendingRecharge'])->name('pending');
            Route::get('success', [OrderController::class, 'successRecharge'])->name('success');
            Route::get('reject', [OrderController::class, 'rejectedRecharge'])->name('rejected');
            Route::put('change-status', [OrderController::class, 'changeStatus'])->name('change.status');
            Route::put('reject-recharge', [OrderController::class, 'rejectRecharge'])->name('reject.recharge');
            Route::get('delete/{id}', [OrderController::class, 'deleteRecharge'])->name('delete.recharge');

        });

        Route::group(['prefix' => 'recharge', 'as' => 'recharge.'], function () {
            Route::get('api-recharge', [RechargeController::class, 'apiIndex'])->name('api.index');
            Route::put('api-recharge-update', [RechargeController::class, 'apiUpdate'])->name('api.update');
            Route::get('pending', [OrderController::class, 'pendingRecharge'])->name('pending');
            Route::get('success', [OrderController::class, 'successRecharge'])->name('success');
            Route::get('reject', [OrderController::class, 'rejectedRecharge'])->name('rejected');
            Route::put('change-status', [OrderController::class, 'changeStatus'])->name('change.status');
            Route::put('reject-recharge', [OrderController::class, 'rejectRecharge'])->name('reject.recharge');
            Route::get('delete/{id}', [OrderController::class, 'deleteRecharge'])->name('delete.recharge');
        });

        Route::group(['prefix' => 'drive', 'as' => 'drive.'], function () {
            Route::get('/', [PackageController::class, 'drivePackageIndex'])->name('index');
            Route::get('add-package', [PackageController::class, 'addDrivePackage'])->name('add');
            Route::post('store-package', [PackageController::class, 'storeDrivePackage'])->name('store');
            Route::get('edit-package/{id}', [PackageController::class, 'editDrivePackage'])->name('edit');
            Route::put('update-package/{id}', [PackageController::class, 'updateDrivePackage'])->name('update');
            Route::get('delete-package/{id}', [PackageController::class, 'deleteDrivePackage'])->name('package.delete');
            Route::post('packages/update-status', [PackageController::class, 'updateStatus'])->name('packages.update.status');

            Route::get('pending', [PackageController::class, 'drivePackagePending'])->name('pending');
            Route::get('success', [PackageController::class, 'drivePackageSuccess'])->name('success');
            Route::get('reject', [PackageController::class, 'drivePackageRejected'])->name('rejected');
            Route::put('change-status', [PackageController::class, 'driveApproved'])->name('order.approved');
            Route::put('reject-drive', [PackageController::class, 'driveRejected'])->name('order.rejected');
            Route::get('delete/{id}', [PackageController::class, 'driveDelete'])->name('delete');

        });

       

        Route::group(['prefix' => 'regular', 'as' => 'regular.'], function () {
            Route::get('/', [PackageController::class, 'regularPackageIndex'])->name('index');
            Route::get('add-package', [PackageController::class, 'addRegularPackage'])->name('add');
            Route::post('store-package', [PackageController::class, 'storeRegularPackage'])->name('store');
            Route::get('edit-package/{id}', [PackageController::class, 'editRegularPackage'])->name('edit');
            Route::put('update-package/{id}', [PackageController::class, 'updateRegularPackage'])->name('update');
            Route::get('delete-package/{id}', [PackageController::class, 'deleteRegularPackage'])->name('package.delete');
            Route::post('packages/update-status', [PackageController::class, 'updateStatus'])->name('packages.update.status');

            Route::get('pending', [PackageController::class, 'regularPackagePending'])->name('pending');
            Route::get('success', [PackageController::class, 'regularPackageSuccess'])->name('success');
            Route::get('reject', [PackageController::class, 'regularPackageRejected'])->name('rejected');
            Route::put('change-status', [PackageController::class, 'regularApproved'])->name('order.approved');
            Route::put('reject-regular', [PackageController::class, 'regularRejected'])->name('order.rejected');
            Route::get('delete/{id}', [PackageController::class, 'regularDelete'])->name('delete');
        });


        Route::group(['prefix' => 'mobile-banking', 'as' => 'mobile-banking.'], function () {
            Route::get('/', [mBankingController::class, 'index'])->name('index');
            Route::get('add-mbank', [mBankingController::class, 'add_mobile_bank'])->name('add');
            Route::post('store-mbanking', [mBankingController::class, 'store_mobile_bank'])->name('store');
            Route::get('edit-mbanking/{id}', [mBankingController::class, 'edit_mobile_bank'])->name('edit');
            Route::put('update-mbanking/{id}', [mBankingController::class, 'update_mobile_bank'])->name('update');
            Route::get('delete-mbanking/{id}', [mBankingController::class, 'delete_mobile_bank'])->name('mbank.delete');

            Route::get('pending', [mBankingController::class, 'mbankingPending'])->name('pending');
            Route::get('success', [mBankingController::class, 'mbankingSuccess'])->name('success');
            Route::get('reject', [mBankingController::class, 'mbankingRejected'])->name('rejected');
            Route::put('change-status', [mBankingController::class, 'mbankingApproved'])->name('order.approved');
            Route::put('reject-mbanking', [mBankingController::class, 'mbankingOrderRejected'])->name('order.rejected');
            Route::get('delete/{id}', [mBankingController::class, 'mbankingDelete'])->name('delete');
        });

        Route::group(['prefix' => 'banking', 'as' => 'banking.'], function () {
            Route::get('/', [BankingController::class, 'index'])->name('index');
            Route::get('add-bank', [BankingController::class, 'addBank'])->name('add');
            Route::post('store-banking', [BankingController::class, 'storeBank'])->name('store');
            Route::get('edit-banking/{id}', [BankingController::class, 'editBank'])->name('edit');
            Route::put('update-banking/{id}', [BankingController::class, 'updateBank'])->name('update');
            Route::get('delete-banking/{id}', [BankingController::class, 'deleteBank'])->name('item.delete');

            Route::get('pending', [BankingController::class, 'bankingPending'])->name('pending');
            Route::get('success', [BankingController::class, 'bankingSuccess'])->name('success');
            Route::get('reject', [BankingController::class, 'bankingRejected'])->name('rejected');
            Route::put('change-status', [BankingController::class, 'bankingApproved'])->name('order.approved');
            Route::put('reject-banking', [BankingController::class, 'bankingOrderRejected'])->name('order.rejected');
            Route::get('delete/{id}', [BankingController::class, 'bankingDelete'])->name('delete');
        });

        Route::group(['prefix' => 'bill', 'as' => 'bill.'], function () {
            Route::get('/', [BillController::class, 'index'])->name('index');
            Route::get('add-bill', [BillController::class, 'addBill'])->name('add');
            Route::post('store-bill', [BillController::class, 'storeBill'])->name('store');
            Route::get('edit-bill/{id}', [BillController::class, 'editBill'])->name('edit');
            Route::put('update-bill/{id}', [BillController::class, 'updateBill'])->name('update');
            Route::get('delete-bill/{id}', [BillController::class, 'deleteBill'])->name('item.delete');

            Route::get('pending', [BillController::class, 'billPending'])->name('pending');
            Route::get('success', [BillController::class, 'billSuccess'])->name('success');
            Route::get('reject', [BillController::class, 'billRejected'])->name('rejected');
            Route::put('change-status', [BillController::class, 'billApproved'])->name('order.approved');
            Route::put('reject-bill', [BillController::class, 'billOrderRejected'])->name('order.rejected');
            Route::get('delete/{id}', [BillController::class, 'billDelete'])->name('delete');
        });

        Route::group(['prefix' => 'remittance', 'as' => 'remittance.'], function () {
            Route::get('/', [RemittanceController::class, 'index'])->name('index');
            Route::get('add-remittance', [RemittanceController::class, 'addRemitProvider'])->name('add');
            Route::post('store-remittance', [RemittanceController::class, 'storeRemitProvider'])->name('store');
            Route::get('edit-remittance/{id}', [RemittanceController::class, 'editRemitProvider'])->name('edit');
            Route::put('update-remittance/{id}', [RemittanceController::class, 'updateRemitProvider'])->name('update');
            Route::get('delete-remittance/{id}', [RemittanceController::class, 'deleteRemitProvider'])->name('item.delete');

            Route::get('pending', [RemittanceController::class, 'remitPending'])->name('pending');
            Route::get('success', [RemittanceController::class, 'remitSuccess'])->name('success');
            Route::get('reject', [RemittanceController::class, 'remitRejected'])->name('rejected');
            Route::put('change-status', [RemittanceController::class, 'remitApproved'])->name('order.approved');
            Route::put('reject-bill', [RemittanceController::class, 'remitOrderRejected'])->name('order.rejected');
            Route::get('delete/{id}', [RemittanceController::class, 'remitDelete'])->name('delete');
        });

        Route::group(['prefix' => 'add-gateway', 'as' => 'add-gateway.'], function () {
            Route::get('/', [GatewayController::class, 'index'])->name('index');
            Route::get('add-money', [GatewayController::class, 'addGateway'])->name('add');
            Route::post('store-bank', [GatewayController::class, 'storeBank'])->name('bank.store');
            Route::post('store-mobile', [GatewayController::class, 'storeMobile'])->name('mobile.store');

            Route::put('update-auto-gateway', [GatewayController::class, 'updateAutoGateWay'])->name('update.auto.gateway');

            Route::get('edit-bank/{id}', [GatewayController::class, 'editBank'])->name('bank.edit');
            Route::get('edit-mobile/{id}', [GatewayController::class, 'editMobile'])->name('mobile.edit');

            Route::put('update-bank/{id}', [GatewayController::class, 'updateBank'])->name('bank.update');
            Route::put('update-mobile/{id}', [GatewayController::class, 'updateMobile'])->name('mobile.update');

            Route::get('delete-mobile/{id}', [GatewayController::class, 'deleteMobile'])->name('mobile.delete');
            Route::get('delete-bank/{id}', [GatewayController::class, 'deleteBank'])->name('bank.delete');


            Route::get('pending', [GatewayController::class, 'addMoneyPending'])->name('pending');
            Route::get('success', [GatewayController::class, 'addMoneySuccess'])->name('success');
            Route::get('reject', [GatewayController::class, 'addMoneyRejected'])->name('rejected');
            Route::put('change-status', [GatewayController::class, 'addMoneyApproved'])->name('order.approved');
            Route::put('reject-bill', [GatewayController::class, 'addMoneyOrderRejected'])->name('order.rejected');
            Route::get('delete/{id}', [GatewayController::class, 'addMoneyDelete'])->name('delete');
        });

        Route::group(['prefix' => 'live-chat', 'as' => 'live-chat.'], function () {
            Route::get('/', [LiveChatController::class, 'index'])->name('index');
            Route::get('messages/{userId}', [LiveChatController::class, 'getMessages'])->name('messages');
            Route::post('send', [LiveChatController::class, 'sendMessage'])->name('send');
        });

        Route::group(['prefix' => 'posts', 'as' => 'offers.'], function () {
            Route::get('/', [DashboardController::class, 'offerIndex'])->name('index');
            Route::post('store', [DashboardController::class, 'storeOffer'])->name('store');
            Route::get('delete/{id}', [DashboardController::class, 'deleteOffer'])->name('delete');
        });

        Route::group(['prefix' => 'videos', 'as' => 'videos.'], function () {
            Route::get('/', [DashboardController::class, 'videoIndex'])->name('index');
            Route::put('update', [DashboardController::class, 'updateVideo'])->name('update');
        });

        Route::group(['prefix' => 'web-settings', 'as' => 'web-settings.'], function () {
            Route::get('/', [FrontendController::class, 'hero'])->name('index');
            Route::put('update-hero', [FrontendController::class, 'updateHero'])->name('update.hero');

            Route::get('about', [FrontendController::class, 'about'])->name('about');
            Route::put('update-about', [FrontendController::class, 'updateAbout'])->name('update.about');

            Route::get('features', [FrontendController::class, 'features'])->name('features');
            Route::put('update-feature', [FrontendController::class, 'updateFeature'])->name('update.feature');

            Route::get('download', [FrontendController::class, 'download'])->name('download');
            Route::put('update-video', [FrontendController::class, 'updateVideo'])->name('update.video');

            Route::post('upload-apk', [FrontendController::class, 'uploadApk'])->name('upload.apk');

            Route::get('screenshots', [FrontendController::class, 'screenshotsIndex'])->name('screenshots');
            Route::put('update-screenshots', [FrontendController::class, 'screenshotDetailsUpdate'])->name('screenshots.update');
            Route::post('upload-screenshot', [FrontendController::class, 'uploadScreenshot'])->name('upload.screenshot');


            Route::get('screenshots/delete/{id}', [FrontendController::class, 'deleteImages'])->name('screenshots.images.delete');
        });

    });

    Route::group(['prefix' => 'user', 'as' => 'user.', 'middleware' => ['auth', 'role:retailer']], function () {
        Route::get('/', [UserDashController::class, 'index'])->name('index');

        Route::group(['prefix' => 'profile', 'as' => 'profile.'], function () {
            Route::get('/', [UserDashController::class, 'profileIndex'])->name('index');
            Route::put('profile-update', [UserDashController::class, 'updateProfile'])->name('update');
            Route::put('password-update', [UserDashController::class, 'updatePassword'])->name('password.update');
            Route::put('pin-update', [UserDashController::class, 'updatePin'])->name('pin.update');
        });


        Route::group(['prefix' => 'packages', 'as' => 'packages.'], function () {
            Route::get('{package}', [UserDashController::class, 'packageIndex'])->name('index');
            Route::get('{operator}/{package_id}', [UserDashController::class, 'packageDetails'])->name('details');
            Route::post('order/place/{item_id}', [UserDashController::class, 'placeOrder'])->name('item.order');
        });


        Route::group(['prefix' => 'add-money', 'as' => 'add-money.'], function () {
            Route::get('bank-addmoney', [UserDashController::class, 'bankAddMoney'])->name('bank.addmoney');
            Route::get('mobile-addmoney', [UserDashController::class, 'mobileAddMoney'])->name('mobile.addmoney');

            Route::get('mobile-addmoney/{id}', [UserDashController::class, 'proceedMAddMoney'])->name('mobile.proceed.addmoney');
            Route::get('bank-addmoney/{id}', [UserDashController::class, 'proceedBAddMoney'])->name('bank.proceed.addmoney');

            Route::post('mBanking-deposit/{mId}', [UserDashController::class, 'mBankingDeposit'])->name('mBanking.deposit');
            Route::post('banking-deposit/{bId}', [UserDashController::class, 'bankingDeposit'])->name('banking.deposit');
        });

        Route::group(['prefix' => 'send-money', 'as' => 'send-money.'], function () {
            Route::get('/', [UserDashController::class, 'sendMoney'])->name('index');
            Route::post('proceed', [UserDashController::class, 'sendMoneyProceed'])->name('proceed');
        });

        Route::group(['prefix' => 'recharge', 'as' => 'recharge.'], function () {
            Route::get('/', [UserDashController::class, 'recharge'])->name('index');
            Route::post('proceed', [UserDashController::class, 'rechargeProceed'])->name('proceed');
        });

        Route::group(['prefix' => 'pay-bill', 'as' => 'pay-bill.'], function () {
            Route::get('/', [UserDashController::class, 'payBill'])->name('index');
            Route::post('proceed', [UserDashController::class, 'payBillProceed'])->name('proceed');
        });

        Route::group(['prefix' => 'remittance', 'as' => 'remittance.'], function () {
            Route::get('/', [UserDashController::class, 'remittance'])->name('index');
            Route::post('proceed', [UserDashController::class, 'remittanceProceed'])->name('proceed');
        });
        
         Route::group(['prefix', 'payment', 'as' => 'payment.'], function () {
        Route::Post('payment/create', [UserDashController::class, 'create'])->name('create');
        Route::get('success', [UserDashController::class, 'success'])->name('success');
        Route::post('webhook', [UserDashController::class, 'webhook'])->name('webhook');
        Route::get('cancel', [UserDashController::class, 'cancel'])->name('cancel');
         });

        Route::group(['prefix' => 'banking', 'as' => 'banking.'], function () {
            Route::get('/', [UserDashController::class, 'banking'])->name('index');
            Route::get('{id}', [UserDashController::class, 'bankingView'])->name('view');
            Route::post('proceed/{name}', [UserDashController::class, 'bankingProceed'])->name('proceed');
        });

        Route::group(['prefix' => 'm-banking', 'as' => 'm-banking.'], function () {
            Route::get('/', [UserDashController::class, 'mBanking'])->name('index');
            Route::get('{id}', [UserDashController::class, 'mBankingView'])->name('view');
            Route::post('proceed/{name}', [UserDashController::class, 'mBankingProceed'])->name('proceed');
        });

        Route::get('history', [UserDashController::class, 'history'])->name('history');
        Route::put('update-token', [FcmController::class, 'updateUserToken'])->name('update.token');


    });
});

if (file_exists(base_path('routes/installer.php'))) {
    require base_path('routes/installer.php');
}
