<?php $__env->startSection('h_title', 'Remittance Order'); ?>
<?php $__env->startSection('remittance_view', 'active'); ?>
<?php $__env->startSection('remittance_main', 'active'); ?>
<?php $__env->startSection('remittance_show', 'show'); ?>
<?php $__env->startSection('remittance_expanded', 'true'); ?>
<?php $__env->startPush('css_cdn'); ?>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css"/>
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css"/>
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('body'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Remittance Orders</h5>
                </div>
                <div class="card-body">
                    <table id="scroll-horizontal" class="table nowrap align-middle" style="width:100%">
                        <thead>
                        <tr>
                            <th scope="col" style="width: 10px;">
                                <div class="form-check">
                                    <input class="form-check-input fs-15" type="checkbox" id="checkAll"
                                           value="option">
                                </div>
                            </th>
                            <th data-ordering="false">#</th>
                            <th data-ordering="false">Name</th>
                            <th data-ordering="false">Bank Name</th>
                            <th data-ordering="false">Recipient Name</th>
                            <th data-ordering="false">Recipient Number</th>
                            <th data-ordering="false">Sender Name</th>
                            <th data-ordering="false">Sender Number</th>
                            <th data-ordering="false">Transfer Amount</th>
                            <th data-ordering="false">Status</th>
                            <th data-ordering="false">Reason</th>
                            <th>Order Date</th>
                            <th>Action</th>

                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <th scope="row">
                                    <div class="form-check">
                                        <input class="form-check-input fs-15" type="checkbox" name="checkAll"
                                               value="option1">
                                    </div>
                                </th>
                                <td><?php echo e($loop->iteration); ?></td>
                                <td>
                                    <span
                                        class="<?php echo e($data->user == null ? 'text-danger':'text-dark'); ?>"><?php echo e($data->user == null ? 'User Not found':$data->user->name); ?></span>
                                </td>
                                <td>
                                    <?php echo e($data->bank_name); ?>

                                </td>
                                <td><?php echo e($data->recipient_name); ?> </td>
                                <td><?php echo e($data->recipient_number); ?> </td>
                                <td><?php echo e($data->sender_name); ?> </td>
                                <td><?php echo e($data->sender_number); ?> </td>
                                <td><?php echo e($data->transfer_amount); ?> BDT
                                    <br> <small
                                        class="text-danger mt-2 mt-2"><?php echo e($data->fee != null ? $data->fee . __(' BDT') : ''); ?></small>
                                </td>
                                <td>
                                    <button
                                        class="btn btn-<?php echo e($data->status == 'pending' ? 'warning' : ($data->status == 'accepted' ? 'success' : 'danger')); ?> waves-effect waves-light btn-sm"><?php echo e($data->status == 'pending' ? 'Pending' : ($data->status == 'accepted' ? 'Accepted' : 'Cancelled')); ?></button>

                                </td>
                                <td class="text-danger"><?php echo e($data->reason == null ? 'N/A' : $data->reason); ?></td>
                                <td><?php echo e(\Carbon\Carbon::make($data->created_at)->format('D, d M Y')); ?></td>
                                <td>
                                    <?php if($data->status === 'pending'): ?>
                                        <!-- Success Button -->
                                        <button
                                            class="btn btn-success waves-effect waves-light success-btn"
                                            data-bs-toggle="modal" data-bs-target="#statusModal"
                                            data-id="<?php echo e($data->id); ?>"
                                            data-bankName="<?php echo e($data->bank_name); ?>"
                                            data-senderName="<?php echo e($data->sender_name); ?>"
                                            data-senderNumber="<?php echo e($data->sender_number); ?>"
                                            data-amount="<?php echo e($data->transfer_amount); ?>"
                                            data-recipientName="<?php echo e($data->recipient_name); ?>"
                                            data-recipientNumber="<?php echo e($data->recipient_number); ?>"
                                        >
                                            <i class="ri-checkbox-circle-line"></i> Success
                                        </button>

                                        <!-- Reject Button -->
                                        <button
                                            class="btn btn-primary waves-effect waves-light reject-btn"
                                            data-bs-toggle="modal" data-bs-target="#rejectModal"
                                            data-id="<?php echo e($data->id); ?>">
                                            <i class="ri-close-circle-line"></i> Reject
                                        </button>

                                        <!-- Delete Button -->
                                        <a href="<?php echo e(route('admin.remittance.delete', $data->id)); ?>"
                                           onclick="return confirmRechargeDelete(this);" data-bs-toggle="tooltip"
                                           data-bs-placement="top" data-bs-title="Delete"
                                           class="btn btn-outline-danger waves-effect waves-light remove-item-btn">
                                            <i class="ri-delete-bin-line"></i> Delete
                                        </a>
                                    <?php elseif($data->status === 'accepted' || $data->status === 'cancelled'): ?>
                                        <!-- Only Delete Button for Success or Rejected Status -->
                                        <a href="<?php echo e(route('admin.remittance.delete', $data->id)); ?>"
                                           onclick="return confirmRechargeDelete(this);" data-bs-toggle="tooltip"
                                           data-bs-placement="top" data-bs-title="Delete"
                                           class="btn btn-outline-danger waves-effect waves-light remove-item-btn">
                                            <i class="ri-delete-bin-line"></i> Delete
                                        </a>
                                    <?php endif; ?>

                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                </div>
            </div>
        </div><!--end col-->
    </div><!--end row-->


    <!-- Approved Modal -->
    <div class="modal fade" id="statusModal" data-bs-backdrop="static" data-bs-keyboard="false"
         tabindex="-1" aria-labelledby="statusModal" aria-hidden="true">
        <div class="modal-dialog">
            <form action="<?php echo e(route('admin.remittance.order.approved')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <input type="hidden" name="success_id" id="success_id">
                <div class="modal-content" style="background-color: white;">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="editUserModalLabel">Order Confirmation</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-6 mb-2">
                                <label for="package_name" class="form-label label text-secondary">Bank Name</label>
                                <div class="position-relative">
                                    <input type="text" class="form-control h-55" id="bank_name" disabled>
                                </div>
                            </div>

                            <div class="col-md-6 mb-2">
                                <label for="pay_amount" class="form-label label text-secondary">Sender Name</label>
                                <div class="position-relative">
                                    <input type="text" class="form-control h-55" id="sender_name"
                                           disabled>
                                </div>
                            </div>

                            <div class="col-md-6 mb-2">
                                <label for="pay_amount" class="form-label label text-secondary">Recipient Name</label>
                                <div class="position-relative">
                                    <input type="text" class="form-control h-55" id="recipient_name"
                                           disabled>
                                </div>
                            </div>

                            <div class="col-lg-6 mb-2">
                                <label for="sender_number" class="form-label text-secondary">Sender Number</label>
                                <div class="input-group">
                                    <input type="text" class="form-control" id="sender_number" disabled>
                                    <button class="btn btn-primary" id="copySndNumber" type="button">Copy
                                    </button>
                                </div>
                            </div>

                            <div class="col-lg-6 mb-2">
                                <label for="recipient_number" class="form-label text-secondary">Recipient Number</label>
                                <div class="input-group">
                                    <input type="text" class="form-control" id="recipient_number" disabled>
                                    <button class="btn btn-primary" id="copyRcpNumber" type="button">Copy
                                    </button>
                                </div>
                            </div>

                            <div class="col-md-6 mb-2">
                                <label for="type"
                                       class="form-label label text-secondary">Amount</label>
                                <div class="position-relative">
                                    <input type="text" class="form-control h-55" id="transfer_amount"
                                           disabled>
                                </div>
                            </div>

                          

                            <div class="col-md-6 mb-2">
                                <label for="type"
                                       class="form-label label text-secondary"><br></label>
                                <button type="submit" class="btn btn-success fw-medium text-white px-4 w-100">
                                    Approved
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>


    <!-- Reject Modal -->
    <div class="modal fade" id="rejectModal" data-bs-backdrop="static" data-bs-keyboard="false"
         tabindex="-1"
         aria-labelledby="rejectModal" aria-hidden="true">
        <div class="modal-dialog">
            <form action="<?php echo e(route('admin.remittance.order.rejected')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <input type="hidden" name="reject_id" id="reject_id">
                <div class="modal-content" style="background-color: white;">
                    <div class="modal-header">
                        <h1 class="modal-title fs-5" id="editUserModalLabel">Remittance Rejection</h1>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>

                    </div>
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-md-12">
                                <label for="validationCustom09" class="form-label label text-secondary">Write Reject
                                    Reason :</label>
                                <div class="position-relative">
                                    <textarea cols="10" rows="4" class="form-control" id="validationCustom09"
                                              placeholder="Reason" name="reason" required></textarea>

                                </div>

                                <?php $__errorArgs = ['reason'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="text-danger m-2"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>

                            <div class="col-md-6 mb-2">
                                <label for="validationCustom10"
                                       class="form-label label text-secondary"> <br> </label>
                                <div class="position-relative">
                                    <button type="submit"
                                            class="btn btn-danger fw-medium text-white">
                                        Submit
                                    </button>
                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </form>
        </div>
    </div>

<?php $__env->stopSection(); ?>
<?php $__env->startPush('js_cdn'); ?>

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"
            integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>

    <script src="<?php echo e(asset('assets/js/pages/datatables.init.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('js'); ?>
    <script>

        function confirmRechargeDelete(element) {
            // Display the confirmation dialog
            if (confirm('Are you sure you want to delete this Remittance? This action cannot be undone.')) {
                // If confirmed, redirect to the deletion URL
                window.location.href = element.href;
                return true; // Allow the browser to follow the link
            } else {
                // If cancelled, do nothing
                return false; // Prevent the browser from following the link
            }
        }

        document.addEventListener('DOMContentLoaded', function () {
            const editButtons = document.querySelectorAll('.success-btn');

            editButtons.forEach(button => {
                button.addEventListener('click', function () {
                    const id = this.getAttribute('data-id');
                    const bank_name = this.getAttribute('data-bankName');
                    const senderName = this.getAttribute('data-senderName');
                    const senderNumber = this.getAttribute('data-senderNumber');
                    const amount = this.getAttribute('data-amount');
                    const recipientName = this.getAttribute('data-recipientName');
                    const recipientNumber = this.getAttribute('data-recipientNumber');

                    // Populate modal fields with the captured data
                    document.getElementById('success_id').value = id;
                    document.getElementById('bank_name').value = bank_name;
                    document.getElementById('sender_name').value = senderName;
                    document.getElementById('recipient_name').value = recipientName;
                    document.getElementById('sender_number').value = senderNumber;
                    document.getElementById('transfer_amount').value = amount + ' BDT';
                    document.getElementById('recipient_number').value = recipientNumber;
                });
            });
        });

        document.addEventListener('DOMContentLoaded', function () {
            const rejectButton = document.querySelectorAll('.reject-btn');

            rejectButton.forEach(button => {
                button.addEventListener('click', function () {
                    const id = this.getAttribute('data-id');
                    document.getElementById('reject_id').value = id;
                });
            });
        });

        document.getElementById('copyNumber').addEventListener('click', function () {
            copyToClipboard('ac_number');
        });

        function copyToClipboard(inputId) {
            // Get the input element by its ID
            const inputElement = document.getElementById(inputId);

            // Temporarily enable the input field to copy its value
            inputElement.disabled = false;
            inputElement.select();

            // Execute the copy command
            document.execCommand('copy');

            // Disable the input field again
            inputElement.disabled = true;

            // Show the alert
            alert('Number copied to clipboard!');
        }


    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Hossain\bkash_copy_admin_change_number\resources\views/remittance/remittance_order.blade.php ENDPATH**/ ?>