<?php $__env->startSection('h_title', 'Commissions'); ?>
<?php $__env->startSection('body'); ?>
    <div class="row">
        <div class="col-xxl-6 col-lg-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Setup Commissions</h5>
                    <hr>

                    <?php $__currentLoopData = $commissions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $commission): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <div class="col-lg-12">
                            <div class="tab-content text-muted mt-3">
                                <div class="tab-pane fade active show" id="custom-v-pills-<?php echo e($commission->id); ?>"
                                     role="tabpanel"
                                     aria-labelledby="custom-v-pills-<?php echo e($commission->id); ?>-tab">
                                    <form action="<?php echo e(route('admin.commissions.update', $commission->id)); ?>"
                                          method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PUT'); ?>
                                        <div class="row mb-3">
                                            <div class="col-lg-3">
                                                <label for="nameInput<?php echo e($commission->id); ?>"
                                                       class="form-label"><?php echo e($commission->name); ?></label>
                                            </div>
                                            <div class="col-lg-9">
                                                <div class="input-group">
                                                    <input type="text" class="form-control"
                                                           id="nameInput<?php echo e($commission->id); ?>"
                                                           value="<?php echo e($commission->amount); ?>"
                                                           name="commission"
                                                           placeholder="Enter commission rate, e.g., 2">
                                                    <span class="input-group-text" id="basic-addon2">%</span>
                                                </div>

                                                <div class="form-check-info mt-3 mb-3">
                                                    <input type="hidden" name="status" value="off">
                                                    <input class="form-check-input" type="checkbox"
                                                           id="formCheck<?php echo e($commission->id); ?>" name="status"
                                                        <?php echo e($commission->status == 'active' ? 'checked' : ''); ?>>
                                                    <label class="form-check-label"
                                                           for="formCheck<?php echo e($commission->id); ?>">
                                                        <?php echo e($commission->status == 'active' ? 'ON' : 'OFF'); ?>

                                                    </label>

                                                </div>

                                                <div class="text-start">
                                                    <button type="submit" class="btn btn-sm btn-primary">Update
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                        <?php if(!$loop->last): ?>
                            <hr>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                </div>
            </div>
        </div>


        <div class="col-xxl-6 col-lg-6">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Setup Fees</h5>
                    <hr>
                    <?php $__currentLoopData = $fees; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fee): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                        <div class="col-lg-12">
                            <div class="tab-content text-muted mt-3">
                                <div class="tab-pane fade active show" id="custom-v-pills-<?php echo e($fee->id); ?>"
                                     role="tabpanel"
                                     aria-labelledby="custom-v-pills-<?php echo e($fee->id); ?>-tab">
                                    <form action="<?php echo e(route('admin.fees.update', $fee->id)); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <?php echo method_field('PUT'); ?>
                                        <div class="row mb-3">
                                            <div class="col-lg-3">
                                                <label for="nameInput<?php echo e($fee->id); ?>" class="form-label"><?php echo e($fee->name); ?>

                                                    Fees</label>
                                            </div>
                                            <div class="col-lg-9">
                                                <div class="input-group">
                                                    <input type="number" class="form-control"
                                                           id="nameInput<?php echo e($fee->id); ?>"
                                                           value="<?php echo e($fee->amount); ?>"
                                                           name="fee"
                                                           placeholder="<?php echo e(getPlaceholderText($fee->name)); ?>">
                                                    <span class="input-group-text"
                                                          id="basic-addon2"><?php echo e(getAttatchedPlaceHolder($fee->name)); ?></span>
                                                </div>

                                                <div class="form-check-info mt-3 mb-3">
                                                    <input type="hidden" name="status" value="off">
                                                    <input class="form-check-input" type="checkbox"
                                                           id="formCheck<?php echo e($fee->id); ?>" name="status"
                                                        <?php echo e($fee->status == 'active' ? 'checked' : ''); ?>>
                                                    <label class="form-check-label"
                                                           for="formCheck<?php echo e($fee->id); ?>">
                                                        <?php echo e($fee->status == 'active' ? 'ON' : 'OFF'); ?>

                                                    </label>

                                                </div>

                                                <div class="text-start">
                                                    <button type="submit" class="btn btn-sm btn-primary">Update
                                                    </button>
                                                </div>
                                            </div>
                                        </div>

                                    </form>
                                </div>
                            </div>
                        </div>
                        <?php if(!$loop->last): ?>
                            <hr>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </div>

    <?php
        function getPlaceholderText($feeName) {
            switch ($feeName) {
                case 'Bank':
                    return 'Enter bank fees rate e.g., 2%';
                case 'Mobile Banking':
                    return 'Enter mobile banking fees amount 10/20 BDT';
                case 'Bill':
                    return 'Enter bill fees amount 10/20 BDT';
                case 'CashOut':
                    return 'Enter all cash out fees rate e.g., 2%';
                case 'Remittance':
                    return 'Enter remittances fees rate e.g., 2%';
                default:
                    return '';
            }
        }

        function getAttatchedPlaceHolder($feeName) {
            switch ($feeName) {
                case 'Remittance':
                case 'CashOut':
                case 'Bank':
                    return '%';
                case 'Bill':
                case 'Mobile Banking':
                    return 'BDT';
                default:
                    return '';
            }
        }
    ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Hossain\bkash_copy_admin_change_number\resources\views/commission/index.blade.php ENDPATH**/ ?>