<?php $__env->startSection('h_title', 'All Remittance Provider'); ?>
<?php $__env->startSection('remittance_view', 'active'); ?>
<?php $__env->startSection('remittance_main', 'active'); ?>
<?php $__env->startSection('remittance_show', 'show'); ?>
<?php $__env->startSection('remittance_expanded', 'true'); ?>
<?php $__env->startPush('css_cdn'); ?>
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css"/>
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css"/>
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">
<?php $__env->stopPush(); ?>
<?php $__env->startSection('body'); ?>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">All Remittance Provider</h5>
                </div>
                <div class="card-body">
                    <table id="scroll-horizontal" class="table nowrap align-middle" style="width:100%">
                        <thead>
                        <tr>
                            <th scope="col" style="width: 10px;">
                                <div class="form-check">
                                    <input class="form-check-input fs-15" type="checkbox" id="checkAll" value="option">
                                </div>
                            </th>
                            <th data-ordering="false">SR No.</th>
                            <th data-ordering="false">Logo</th>
                            <th data-ordering="false">Type</th>
                            <th data-ordering="false">Name</th>
                            <th data-ordering="false">Slug</th>
                            <th data-ordering="false">Status</th>
                            <th>Created At</th>
                            <th>Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php $__currentLoopData = $remits; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $data): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <th scope="row">
                                    <div class="form-check">
                                        <input class="form-check-input fs-15" type="checkbox" name="checkAll"
                                               value="option1">
                                    </div>
                                </th>
                                <td><?php echo e($loop->iteration); ?></td>
                                <td><img src="<?php echo e(asset($data->logo)); ?>" alt="<?php echo e($data->name); ?>"
                                         style="height: 50px; width: 50px;"></td>
                                <td><?php echo e($data->type); ?></td>
                                <td><?php echo e($data->name); ?></td>
                                <td><?php echo e($data->slug); ?></td>
                                <td>
                                    <button style="width: 50px;"
                                            class="btn btn-<?php echo e($data->status == 1 ? 'primary' : 'danger'); ?> waves-effect waves-light btn-sm"><?php echo e($data->status == 1 ? 'On' : 'Off'); ?></button>

                                </td>
                                <td><?php echo e(\Carbon\Carbon::make($data->created_at)->format('D, d M Y')); ?></td>
                                <td>
                                    <a href="<?php echo e(route('admin.remittance.edit', $data->id)); ?>"
                                       class="btn btn-outline-primary btn-icon waves-effect waves-light"><i
                                            class="ri-edit-box-line"></i></a>
                                    <a href="<?php echo e(route('admin.remittance.item.delete', $data->id)); ?>"
                                       class="btn btn-outline-danger btn-icon waves-effect waves-light remove-item-btn"><i
                                            class="ri-delete-bin-line"></i></a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </tbody>
                    </table>
                </div>
            </div>
        </div><!--end col-->
    </div><!--end row-->

<?php $__env->stopSection(); ?>
<?php $__env->startPush('js_cdn'); ?>

    <script src="https://code.jquery.com/jquery-3.7.1.min.js"
            integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

    <script src="<?php echo e(asset('assets/js/pages/datatables.init.js')); ?>"></script>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('js'); ?>
    <script>
        $(document).on("click", ".remove-item-btn", function (e) {
            e.preventDefault(); // Prevent default action
            var link = $(this).attr('href'); // Get the href attribute

            Swal.fire({
                title: "Are you sure?",
                text: "You can't restore the item",
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: "Yes, delete",
                cancelButtonText: "Cancel",
                buttonsStyling: false,
                customClass: {
                    confirmButton: 'btn btn-primary w-xs me-2 mt-2',
                    cancelButton: 'btn btn-danger w-xs mt-2'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire({
                        title: "Deleted!",
                        text: "Item has been deleted.",
                        icon: "success",
                        confirmButtonClass: "btn btn-primary w-xs mt-2",
                        buttonsStyling: false
                    }).then(() => {
                        window.location.href = link; // Redirect after showing success message
                    });
                }
            });
        });
    </script>
<?php $__env->stopPush(); ?>


<?php echo $__env->make('main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Hossain\bkash_copy_admin_change_number\resources\views/remittance/index.blade.php ENDPATH**/ ?>