<?php $__env->startSection('h_title', 'Sms  & Notification Configuration'); ?>
<?php $__env->startSection('body'); ?>
    <div class="row">
        <div class="col-xxl-4 col-lg-4">
            <!-- App Permission Card -->
            <div class="card mb-4">
                <div class="card-body">
                    <h5 class="card-title">App Permission</h5>
                    <div class="col-lg-12">
                        <div class="tab-content text-muted mt-3">
                            <div class="tab-pane fade active show">
                                <form method="POST" action="<?php echo e(route('admin.permissions.update')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="mb-3">
                                                <label for="name" class="form-label">Permission Name</label>
                                                <input type="text" class="form-control" value="<?php echo e($permission->name); ?>" placeholder="API URL" disabled>
                                            </div>

                                            <div class="mb-3">
                                                <select class="form-select mb-3" name="status">
                                                    <option selected disabled>Select Status</option>
                                                    <option value="active" <?php echo e($permission->status == 'active'? 'selected': ''); ?>>Active</option>
                                                    <option value="inactive" <?php echo e($permission->status == 'inactive'? 'selected': ''); ?>>Inactive</option>
                                                </select>
                                                <?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="hstack gap-2 justify-content-end">
                                                <button type="submit" class="btn btn-primary">Update</button>
                                                <button type="button" class="btn btn-soft-success">Cancel</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div> <!-- tab-pane -->
                        </div>
                    </div>
                </div>
            </div>

            <!-- OTP Configuration Card -->
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">OTP Configuration</h5>
                    <div class="col-lg-12">
                        <div class="tab-content text-muted mt-3">
                            <div class="tab-pane fade active show">
                                <form method="POST" action="<?php echo e(route('admin.sms-configuration.update')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="mb-3">
                                                <label class="form-label">Service Name</label>
                                                <input type="text" class="form-control" value="<?php echo e($apiSms->name); ?>" placeholder="API URL" disabled>
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">API KEY</label>
                                                <input type="text" class="form-control" name="api_key" placeholder="API KEY" value="<?php echo e($apiSms->api_key); ?>">
                                                <?php $__errorArgs = ['api_key'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="mb-3">
                                                <label class="form-label">Sender ID</label>
                                                <input type="text" class="form-control" name="sender_id" value="<?php echo e($apiSms->sender_id); ?>" placeholder="API username">
                                                <?php $__errorArgs = ['sender_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger"><?php echo e($message); ?></span>
                                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                            </div>

                                            <div class="hstack gap-2 justify-content-end">
                                                <button type="submit" class="btn btn-primary">Update</button>
                                                <button type="button" class="btn btn-soft-success">Cancel</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>
                            </div> <!-- tab-pane -->
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xxl-4 col-lg-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Firebase Json File</h5>

                    <?php if($fileExists): ?>
                        <h6>Current Credentials:</h6>
                        <pre><?php echo e($fileContents); ?></pre>
                    <?php else: ?>
                        <p>No credentials file found.</p>
                    <?php endif; ?>

                    <div class="col-lg-12">
                        <div class="tab-content text-muted mt-3">
                            <div class="tab-pane fade active show" id="custom-v-pills-bank-gateway" role="tabpanel"
                                 aria-labelledby="custom-v-pills-bank-gateway-tab">

                                <form method="POST" action="<?php echo e(route('admin.update.json')); ?>"
                                      enctype="multipart/form-data">
                                    <?php echo csrf_field(); ?>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="mb-3">
                                                <label for="firebase_api_key" class="form-label">Firebase JSON </label>
                                                <input type="file" class="form-control" id="json_file" name="json_file"
                                                       accept=".json" required>
                                            </div>


                                            <div class="hstack gap-2 justify-content-end">
                                                <button type="submit" class="btn btn-primary">Upload</button>
                                                <button type="button" class="btn btn-soft-success">Cancel</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-xxl-4 col-lg-4">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Notification Configuration</h5>
                    <div class="col-lg-12">
                        <div class="tab-content text-muted mt-3">
                            <div class="tab-pane fade active show" id="custom-v-pills-bank-gateway" role="tabpanel"
                                 aria-labelledby="custom-v-pills-bank-gateway-tab">

                                <form method="POST" action="<?php echo e(route('admin.update.firebase')); ?>">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('PUT'); ?>
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <div class="mb-3">
                                                <label for="firebase_api_key" class="form-label">Firebase API
                                                    Key</label>
                                                <input type="text" class="form-control" name="firebase_api_key"
                                                       value="<?php echo e(old('firebase_api_key', $firebaseApiKey )); ?>"
                                                       placeholder="FIREBASE API KEY">
                                            </div>

                                            <div class="mb-3">
                                                <label for="firebase_auth_domain" class="form-label">Firebase Auth
                                                    Domain</label>
                                                <input type="text" class="form-control" name="firebase_auth_domain"
                                                       value="<?php echo e(old('firebase_auth_domain', $firebaseAuthDomain )); ?>"
                                                       placeholder="FIREBASE AUTH DOMAIN">
                                            </div>

                                            <div class="mb-3">
                                                <label for="firebase_project_id" class="form-label">Firebase Project
                                                    ID</label>
                                                <input type="text" class="form-control" name="firebase_project_id"
                                                       value="<?php echo e(old('firebase_project_id', $firebaseProjectId )); ?>"
                                                       placeholder="FIREBASE PROJECT ID">
                                            </div>

                                            <div class="mb-3">
                                                <label for="firebase_messaging_sender_id" class="form-label">Firebase
                                                    Messaging Sender ID</label>
                                                <input type="text" class="form-control"
                                                       name="firebase_messaging_sender_id"
                                                       value="<?php echo e(old('firebase_messaging_sender_id', $firebaseMessagingSenderId )); ?>"
                                                       placeholder="FIREBASE MESSAGING SENDER ID">
                                            </div>

                                            <div class="mb-3">
                                                <label for="firebase_app_id" class="form-label">Firebase App ID</label>
                                                <input type="text" class="form-control" name="firebase_app_id"
                                                       value="<?php echo e(old('firebase_app_id', $firebaseAppId )); ?>"
                                                       placeholder="FIREBASE APP ID">
                                            </div>

                                            <div class="mb-3">
                                                <label for="firebase_measurement_id" class="form-label">Firebase
                                                    Measurement ID</label>
                                                <input type="text" class="form-control" name="firebase_measurement_id"
                                                       value="<?php echo e(old('firebase_measurement_id', $firebaseMeasurementId )); ?>"
                                                       placeholder="FIREBASE MEASUREMENT ID">
                                            </div>

                                            <div class="mb-3">
                                                <label for="firebase_measurement_id" class="form-label">Web Push
                                                    Certificate Key</label>
                                                <input type="text" class="form-control" name="firebase_vapi_key"
                                                       value="<?php echo e(old('firebase_vapi_key', $firebase_vapi_key )); ?>"
                                                       placeholder="Web Push certificate key">
                                            </div>

                                            <div class="hstack gap-2 justify-content-end">
                                                <button type="submit" class="btn btn-primary">Update</button>
                                                <button type="button" class="btn btn-soft-success">Cancel</button>
                                            </div>
                                        </div>
                                    </div>
                                </form>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Hossain\bkash_copy_admin_change_number\resources\views/support/sms_api.blade.php ENDPATH**/ ?>