<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8"/>
    <title>Password Reset</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- favicon -->
    <link rel="shortcut icon" href="<?php echo e($settings->brandLogo); ?>">
    <!-- Bootstrap -->
    <link href="<?php echo e(asset('u_dash/assets/css/bootstrap.min.css')); ?>" rel="stylesheet" type="text/css"/>
    <!-- simplebar -->
    <link href="<?php echo e(asset('u_dash/assets/css/simplebar.css')); ?>" rel="stylesheet" type="text/css"/>
    <!-- Icons -->
    <link href="<?php echo e(asset('u_dash/assets/css/materialdesignicons.min.css')); ?>" rel="stylesheet" type="text/css"/>
    <link href="<?php echo e(asset('u_dash/assets/css/tabler-icons.min.css')); ?>" rel="stylesheet" type="text/css"/>
    <link href="https://unicons.iconscout.com/release/v3.0.6/css/line.css" rel="stylesheet">
    <!-- Css -->
    <link href="<?php echo e(asset('u_dash/assets/css/style.css')); ?>" rel="stylesheet" type="text/css" id="theme-opt"/>
</head>

<body>
<!-- Loader -->
<div id="preloader">
    <div id="status">
        <div class="spinner">
            <div class="double-bounce1"></div>
            <div class="double-bounce2"></div>
        </div>
    </div>
</div>
<!-- Loader -->

<section class="bg-home bg-circle-gradiant d-flex align-items-center">
    <div class="bg-overlay bg-overlay-white"></div>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-lg-5">
                <div class="form-signin p-4 bg-white rounded shadow">
                    <form id="otpForm">
                        <?php echo csrf_field(); ?>
                        <a href="<?php echo e(route('index')); ?>">
                            <img src="<?php echo e($settings->brandLogo); ?>" class="avatar mb-4 d-block mx-auto" alt=""
                                 style="height: 24px; width: 15vh;">
                        </a>
                        <h5 class="mb-3 text-center">পাসওয়ার্ড রিসেট করুন</h5>

                        <p class="text-muted">মোবাইল নম্বরটি লিখুন। একটি OTP পাঠানো হবে। সেটি দিয়ে নতুন পাসওয়ার্ড সেট করুন।</p>

                        <div class="form-group mb-3" id="phoneSection">
                            <label for="phone">মোবাইল নম্বর</label>
                            <input type="text" id="phone" name="phone" class="form-control" placeholder="01*********" required>
                        </div>

                        <button type="button" id="sendOtpBtn" class="btn btn-primary w-100">OTP পাঠান</button>

                        <div id="otpSection" style="display: none;">
                            <div class="form-group mt-3">
                                <label for="otp">প্রাপ্ত OTP লিখুন</label>
                                <input type="text" id="otp" name="otp" class="form-control" required>
                            </div>
                            <button type="button" id="verifyOtpBtn" class="btn btn-success w-100 mt-2">OTP যাচাই করুন</button>
                        </div>

                        <div id="passwordSection" style="display: none;">
                            <div class="form-group mt-3">
                                <label for="password">নতুন পাসওয়ার্ড</label>
                                <input type="password" id="password" name="password" class="form-control" required>
                            </div>
                            <div class="form-group mt-2">
                                <label for="password_confirmation">পাসওয়ার্ড নিশ্চিত করুন</label>
                                <input type="password" id="password_confirmation" name="password_confirmation" class="form-control" required>
                            </div>
                            <button type="submit" class="btn btn-info w-100 mt-2">পাসওয়ার্ড পরিবর্তন করুন</button>
                        </div>

                        <div class="alert mt-3" id="alert" style="display: none;"></div>

                        <div class="col-12 text-center mt-3">
                            <p class="mb-0 mt-3"><small class="text-dark me-2">পাসওয়ার্ড মনে আছে?</small>
                                <a href="<?php echo e(route('login')); ?>" class="text-dark fw-bold">লগইন করুন</a></p>
                        </div>

                        <p class="mb-0 text-muted mt-3 text-center">©
                            <script>document.write(new Date().getFullYear())</script>
                            Landrick.
                        </p>
                    </form>

                </div>
            </div>
        </div>
    </div>
</section>

<!-- javascript -->
<script src="<?php echo e(asset('u_dash/assets/js/bootstrap.bundle.min.js')); ?>"></script>
<!-- simplebar -->
<script src="<?php echo e(asset('u_dash/assets/js/simplebar.min.js')); ?>"></script>
<!-- Icons -->
<script src="<?php echo e(asset('u_dash/assets/js/feather.min.js')); ?>"></script>
<!-- Main Js -->
<script src="<?php echo e(asset('u_dash/assets/js/plugins.init.js')); ?>"></script>
<script src="<?php echo e(asset('u_dash/assets/js/app.js')); ?>"></script>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>

<script>
    let phone = '';

    $('#sendOtpBtn').click(function () {
        phone = $('#phone').val();
        if (!phone) {
            $('#alert').removeClass().addClass('alert alert-warning').text('মোবাইল নম্বর দিন।').show();
            return;
        }
        $.post('<?php echo e(route('send.otp')); ?>', {
            _token: '<?php echo e(csrf_token()); ?>',
            phone: phone
        }, function (data) {
            if (data.status) {
                $('#alert').removeClass().addClass('alert alert-success').text(data.data.success).show();
                $('#otpSection').slideDown();
                $('#phoneSection, #sendOtpBtn').hide();
            } else {
                $('#alert').removeClass().addClass('alert alert-danger').text(data.data.error).show();
            }
        });
    });

    $('#verifyOtpBtn').click(function () {
        const otp = $('#otp').val();
        if (!otp) {
            $('#alert').removeClass().addClass('alert alert-warning').text('OTP দিন।').show();
            return;
        }
        $.post('<?php echo e(route('verify.otp')); ?>', {
            _token: '<?php echo e(csrf_token()); ?>',
            phone: phone,
            otp: otp
        }, function (data) {
            if (data.status) {
                $('#alert').removeClass().addClass('alert alert-success').text(data.data.success).show();
                $('#otpSection').slideUp();
                $('#passwordSection').slideDown();
            } else {
                $('#alert').removeClass().addClass('alert alert-danger').text(data.data.error).show();
            }
        });
    });

    $('#otpForm').submit(function (e) {
        e.preventDefault();
        const password = $('#password').val();
        const confirm = $('#password_confirmation').val();

        if (password !== confirm) {
            $('#alert').removeClass().addClass('alert alert-warning').text("পাসওয়ার্ড মিলছে না").show();
            return;
        }

        $.post('<?php echo e(route('reset.password')); ?>', {
            _token: '<?php echo e(csrf_token()); ?>',
            service_code: 6484,
            phone: phone,
            password: password,
            password_confirmation: confirm
        }, function (data) {
            if (data.status) {
                $('#alert').removeClass().addClass('alert alert-success').text(data.message).show();
                $('#otpForm')[0].reset();
                $('#otpSection, #passwordSection').hide();

                setTimeout(function() {
                    window.location.href = '<?php echo e(route('login')); ?>';
                }, 2000);
            } else {
                let errText = '';
                if (typeof data.errors === 'object') {
                    for (const key in data.errors) {
                        errText += data.errors[key] + ' ';
                    }
                } else {
                    errText = data.errors || 'কিছু একটা ভুল হয়েছে।';
                }
                $('#alert').removeClass().addClass('alert alert-danger').text(errText).show();
            }
        });
    });
</script>

</body>

</html>
<?php /**PATH E:\Hossain\bkash_copy_admin_change_number\resources\views/auth/forgot-password.blade.php ENDPATH**/ ?>