<?php $__env->startSection('h_title', 'Live Chat'); ?>
<?php $__env->startPush('css'); ?>
    <style>
        .chat-message {
            padding: 10px;
            margin: 10px;
            border-radius: 8px;
            max-width: 70%;
            display: inline-block;
            clear: both;
        }

        .chat-message.sender {
            background-color: #f1f1f1;
            text-align: right;
            float: right;
            margin-left: auto;
        }

        .chat-message.receiver {
            background-color: mediumpurple !important;
            color: white;
            text-align: left;
            float: left;
            margin-right: auto;
        }
    </style>
<?php $__env->stopPush(); ?>
<?php $__env->startSection('body'); ?>
    <div class="container mt-4">
        <div class="row">
            <div class="col-md-4">
                <div class="card">
                    <div class="card-header">
                        <h5>Users</h5>
                    </div>
                    <div class="card-body">
                        <ul class="list-group" id="user-list">
                            <?php if(auth()->user()->role == 'admin'): ?>
                                <?php $__currentLoopData = $usersWithMessages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <a href="javascript:void(0);" class="username" data-id="<?php echo e($user->id); ?>"
                                           data-name="<?php echo e($user->name); ?>"  data-phone="<?php echo e($user->phone); ?>"><?php echo e($user->name); ?> <br>
                                            <span><?php echo e($user->phone); ?></span></a>
                                        <span class="badge bg-danger new-message-count"
                                              data-id="<?php echo e($user->id); ?>"><?php echo e($user->unread_message_count); ?></span>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php elseif(auth()->user()->role == 'user'): ?>
                                <?php $__currentLoopData = $admins; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $admin): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="list-group-item d-flex justify-content-between align-items-center">
                                        <a href="javascript:void(0);" class="username" data-id="<?php echo e($admin->id); ?>"
                                           data-name="<?php echo e($admin->name); ?>"
                                           data-phone="<?php echo e($admin->phone); ?>"><?php echo e($admin->name); ?></a>
                                        <span class="badge bg-danger new-message-count"
                                              data-id="<?php echo e($admin->id); ?>">0</span>
                                    </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endif; ?>
                        </ul>
                    </div>
                </div>
            </div>

            <div class="col-md-8">
                <div class="card">
                    <div class="card-header">
                        <h5 class="conversation-name">Select a user</h5>
                        <span class="conversation-phone"></span>
                    </div>
                    <div class="card-body chat-conversation-list" style="height: 400px; overflow-y: auto;">
                    </div>
                    <div class="card-footer">
                        <form id="chatinput-form">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" id="receiver_id">
                            <div class="input-group">
                                <input type="text" class="form-control" id="chat-input"
                                       placeholder="Type your message..." autocomplete="off">
                                <button type="submit" class="btn btn-primary">Send</button>
                                <button type="button" id="close-chat" class="btn btn-danger"
                                        style="display: none;">Close Chat
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('js'); ?>
    <script src="https://js.pusher.com/7.0/pusher.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            function scrollToBottom() {
                var chatList = document.querySelector('.chat-conversation-list');
                chatList.scrollTop = chatList.scrollHeight;
            }

            var pusher = new Pusher('81168b9009d5a572d433', {
                cluster: 'ap2',
                encrypted: true
            });

            var channel = pusher.subscribe('admin-messages.' + <?php echo e(Auth::id()); ?>);

            channel.bind('admin-message', function (data) {
                console.log('Received message:', data);

                let chatList = document.querySelector('.chat-conversation-list');
                if (!chatList) {
                    console.error('Chat list element not found');
                    return;
                }

                let messageElement = document.createElement('div');
                messageElement.classList.add('chat-message');
                messageElement.classList.add(data.user.id == <?php echo e(auth()->id()); ?> ? 'sender' : 'receiver');
                messageElement.innerHTML = `
                    <p>${data.message}</p>
                    <small>${formatDateTime(data.createdAt)}</small>
                `;
                chatList.appendChild(messageElement);

                let badge = document.querySelector(`.new-message-count[data-id="${data.user.id}"]`);
                if (badge) {
                    let count = parseInt(badge.innerText) || 0;
                    count++;
                    badge.innerText = count;
                    badge.style.display = 'inline-block';
                }

                scrollToBottom();
            });

            document.addEventListener('click', function (event) {
                if (event.target.classList.contains('username')) {
                    let userId = event.target.getAttribute('data-id');
                    let userName = event.target.getAttribute('data-name');
                    let userPhone = event.target.getAttribute('data-phone');

                    if (!userId || !userName) {
                        alert("User ID or Name not found!");
                        return;
                    }

                    document.querySelector('.conversation-name').innerText = userName;
                    document.querySelector('.conversation-phone').innerText = userPhone;
                    document.getElementById('receiver_id').value = userId;


                    fetch('<?php echo e(route("admin.live-chat.messages", ["userId" => ":userId"])); ?>'.replace(':userId', userId))
                        .then(response => response.json())
                        .then(data => {
                            let chatList = document.querySelector('.chat-conversation-list');
                            chatList.innerHTML = ""; // Clear old messages

                            data.messages.forEach(msg => {
                                let messageElement = document.createElement('div');
                                messageElement.classList.add('chat-message');
                                messageElement.classList.add(msg.sender_id ==
                                <?php echo e(auth()->id()); ?> ? 'sender' : 'receiver');
                                messageElement.innerHTML = `
                                    <p>${msg.message}</p>
                                    <small>${formatDateTime(msg.created_at)}</small>
                                `;
                                chatList.appendChild(messageElement);
                            });

                            scrollToBottom();
                        })
                        .catch(error => console.error('Error:', error));
                }
            });

            document.getElementById('chatinput-form').addEventListener('submit', function (event) {
                event.preventDefault();

                let inputField = document.getElementById('chat-input');
                let message = inputField.value.trim();
                let receiverId = document.getElementById('receiver_id').value;

                if (message === "" || receiverId === "") {
                    alert("Please enter a message and select a user!");
                    return;
                }

                fetch('<?php echo e(route('admin.live-chat.send')); ?>', {
                    method: 'POST',
                    headers: {
                        'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')
                            .getAttribute('content'),
                        'Content-Type': 'application/json'
                    },
                    body: JSON.stringify({
                        message: message,
                        receiver_id: receiverId
                    }),
                })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            let chatList = document.querySelector('.chat-conversation-list');

                            let messageElement = document.createElement('div');
                            messageElement.classList.add('chat-message', 'sender');
                            messageElement.innerHTML = `
                            <p>${message}</p>
                            <small>Just now</small>
                        `;
                            chatList.appendChild(messageElement);

                            scrollToBottom();

                            inputField.value = "";
                        }
                    })
                    .catch(error => console.error('Error:', error));
            });

            function formatDateTime(dateString) {
                const options = {
                    weekday: 'long',
                    year: 'numeric',
                    month: 'long',
                    day: 'numeric',
                    hour: '2-digit',
                    minute: '2-digit',
                    second: '2-digit',
                    hour12: true
                };
                const date = new Date(dateString);
                return date.toLocaleString('en-US', options);
            }
        });
    </script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('main', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Hossain\bkash_copy_admin_change_number\resources\views/live_chat/index.blade.php ENDPATH**/ ?>