@extends('main')
@section('h_title', 'Edit Packages')
@section('package_main', 'active')
@section('package_main_expand', 'true')
@section('package_show_main', 'show')
@section('drive_main', 'active')
@section('drive_show', 'show')
@section('drive_view', 'active')
@section('body')
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header align-items-center d-flex">
                    <h4 class="card-title mb-0 flex-grow-1">Edit {{ $package->name }}</h4>
                </div><!-- end card header -->
                <div class="card-body">

                    <form action="{{ route('admin.drive.update', $package->slug) }}" method="POST">
                        @csrf
                        @method('PUT')
                        <div class="row">
                            <div class="col-lg-6 col-md-6 col-sm-12">
                                <div class="mb-3">
                                    <label for="name" class="form-label">Offer Name</label>
                                    <input type="text" class="form-control" placeholder="Enter offer name"
                                           name="name" value="{{ $package->name }}"
                                           id="name">
                                    @error('name')
                                    <span class="text-danger mt-2">{{ $message }}</span>
                                    @enderror
                                </div>

                            </div><!--end col-->
                            <div class="col-lg-3 col-md-3 col-sm-12">
                                <div class="mb-3">
                                    <label for="buying_price" class="form-label">Buying Price</label>
                                    <input type="number" class="form-control" placeholder="Enter your buying price"
                                           name="buying_price" value="{{ $package->buying_price }}"
                                           id="buying_price">
                                    @error('buying_price')
                                    <span class="text-danger mt-2">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div><!--end col-->

                            <div class="col-lg-3 col-md-3 col-sm-12">
                                <div class="mb-3">
                                    <label for="selling_price" class="form-label">Selling Price</label>
                                    <input type="number" class="form-control" placeholder="Enter selling price"
                                           name="selling_price" value="{{ $package->selling_price }}"
                                           id="selling_price">
                                    @error('selling_price')
                                    <span class="text-danger mt-2">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-3 col-sm-12">
                                <div class="mb-3">
                                    <label for="discount_price" class="form-label">Discount</label>
                                    <input type="number" class="form-control" placeholder="Enter discount price"
                                           name="discount_price" value="{{ $package->discount_price }}"
                                           id="discount_price">
                                    @error('discount_price')
                                    <span class="text-danger mt-2">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div><!--end col-->

                            <div class="col-lg-3 col-md-3 col-sm-12">
                                <div class="mb-3">
                                    <label for="operator" class="form-label">Operator</label>
                                    <select id="operator" class="form-select" name="operator">
                                        <option selected disabled>Choose...</option>
                                        <option {{ $package->operator == 'Robi' ? 'selected': ''}}>Robi</option>
                                        <option {{ $package->operator == 'Airtel' ? 'selected': ''}}>Airtel</option>
                                        <option {{ $package->operator == 'Skitto' ? 'selected': ''}}>Skitto</option>
                                        <option {{ $package->operator == 'Teletalk' ? 'selected': ''}}>Teletalk</option>
                                        <option {{ $package->operator == 'Banglalink' ? 'selected': ''}}>Banglalink
                                        </option>
                                        <option {{ $package->operator == 'Grameenphone' ? 'selected': ''}}>
                                            Grameenphone
                                        </option>
                                    </select>

                                    @error('operator')
                                    <span class="text-danger mt-2">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div><!--end col-->

                            <div class="col-lg-3 col-md-3 col-sm-12">
                                <div class="mb-3">
                                    <label for="package" class="form-label">Package</label>
                                    <input type="text" class="form-control" placeholder="Package Type"
                                           name="package" value="{{ $package->package }}" disabled
                                           id="package">
                                    @error('package')
                                    <span class="text-danger mt-2">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div><!--end col-->

                            <div class="col-lg-3 col-md-3 col-sm-12">
                                <div class="mb-3">
                                    <label for="validity" class="form-label">Validity</label>
                                    <input type="text" class="form-control" placeholder="Enter offer validity"
                                           value="{{ $package->validity }}"
                                           id="validity" name="validity">
                                    @error('validity')
                                    <span class="text-danger mt-2">{{ $message }}</span>
                                    @enderror
                                </div>
                            </div><!--end col-->

                            <div class="col-lg-12">
                                <div class="text-end">
                                    <button type="submit" class="btn btn-primary">Submit</button>
                                </div>
                            </div><!--end col-->
                        </div><!--end row-->
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
