@extends('main')
@section('h_title', 'All Regular Packages')
@section('package_main', 'active')
@section('package_main_expand', 'true')
@section('package_show_main', 'show')
@section('regular_main', 'active')
@section('regular_show', 'show')
@section('regular_view', 'active')

@push('css_cdn')
    <link rel="stylesheet" href="https://cdn.datatables.net/1.11.5/css/dataTables.bootstrap5.min.css"/>
    <link rel="stylesheet" href="https://cdn.datatables.net/responsive/2.2.9/css/responsive.bootstrap.min.css"/>
    <link rel="stylesheet" href="https://cdn.datatables.net/buttons/2.2.2/css/buttons.dataTables.min.css">
@endpush

@section('body')
    <div class="row">
        <div class="col-lg-12">

            <!-- একসাথে Status পরিবর্তনের বাটন -->
            <div class="mb-3">
                <button id="activateSelected" class="btn btn-success">Activate Selected</button>
                <button id="deactivateSelected" class="btn btn-danger">Deactivate Selected</button>
            </div>

            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">All Regular Packages</h5>
                </div>
                <div class="card-body">
                    <table id="scroll-horizontal" class="table nowrap align-middle" style="width:100%">
                        <thead>
                        <tr>
                            <th scope="col" style="width: 10px;">
                                <div class="form-check">
                                    <input class="form-check-input fs-15" type="checkbox" id="checkAll">
                                </div>
                            </th>
                            <th>SR No.</th>
                            <th>Operator</th>
                            <th>Package</th>
                            <th>Name</th>
                            <th>Buying</th>
                            <th>Selling</th>
                            <th>Discount</th>
                            <th>Validity</th>
                            <th>Status</th>
                            <th>Created At</th>
                            <th>Action</th>
                        </tr>
                        </thead>
                        <tbody>
                        @foreach($packages as $data)
                            <tr>
                                <td>
                                    <div class="form-check">
                                        <input class="form-check-input fs-15" type="checkbox" name="selected_packages[]" value="{{ $data->id }}">
                                    </div>
                                </td>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $data->operator }}</td>
                                <td>{{ $data->package }}</td>
                                <td>{{ $data->name }}</td>
                                <td>{{ $data->buying_price }} BDT</td>
                                <td>{{ $data->selling_price }} BDT</td>
                                <td>{{ $data->discount_price }} BDT</td>
                                <td>{{ $data->validity }}</td>
                                <td>{{ \Carbon\Carbon::make($data->created_at)->format('D, d M Y') }}</td>
                                <td>
                                    <button
                                        class="btn btn-{{ $data->status == 'active' ? 'success' : 'danger' }} waves-effect waves-light btn-sm">{{ $data->status == 'active' ? 'Active':'Deactivate' }}</button>

                                </td>
                                <td>
                                    <a href="{{ route('admin.regular.edit', $data->id) }}" class="btn btn-outline-primary btn-icon waves-effect waves-light"><i class="ri-edit-box-line"></i></a>
                                    <a href="{{ route('admin.regular.package.delete', $data->id) }}" class="btn btn-outline-danger btn-icon waves-effect waves-light remove-item-btn"><i class="ri-delete-bin-line"></i></a>
                                </td>
                            </tr>
                        @endforeach
                        </tbody>
                    </table>
                </div>
            </div>

        </div><!--end col-->
    </div><!--end row-->
@endsection

@push('js_cdn')
    <script src="https://code.jquery.com/jquery-3.7.1.min.js" crossorigin="anonymous"></script>
    <!--datatable js-->
    <script src="https://cdn.datatables.net/1.11.5/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.11.5/js/dataTables.bootstrap5.min.js"></script>
    <script src="https://cdn.datatables.net/responsive/2.2.9/js/dataTables.responsive.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/dataTables.buttons.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.print.min.js"></script>
    <script src="https://cdn.datatables.net/buttons/2.2.2/js/buttons.html5.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/vfs_fonts.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/pdfmake/0.1.53/pdfmake.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jszip/3.1.3/jszip.min.js"></script>

    <script src="{{ asset('assets/js/pages/datatables.init.js')}}"></script>
@endpush

@push('js')
    <script>
        $(document).ready(function() {
            // সব চেকবক্স সিলেক্ট/ডিসিলেক্ট করার জন্য
            $('#checkAll').on('change', function() {
                $('input[name="selected_packages[]"]').prop('checked', $(this).prop('checked'));
            });

            // Activate বাটন ক্লিক করলে
            $('#activateSelected').click(function() {
                updateStatusForSelected('active');
            });

            // Deactivate বাটন ক্লিক করলে
            $('#deactivateSelected').click(function() {
                updateStatusForSelected('deactive');
            });

            function updateStatusForSelected(status) {
                var selected = [];
                $('input[name="selected_packages[]"]:checked').each(function() {
                    selected.push($(this).val());
                });

                if(selected.length === 0){
                    Swal.fire('Warning', 'কমপক্ষে একটি প্যাকেজ সিলেক্ট করুন', 'warning');
                    return;
                }

                $.ajax({
                    url: '{{ route("admin.regular.packages.update.status") }}',
                    method: 'POST',
                    data: {
                        _token: '{{ csrf_token() }}',
                        package_ids: selected,
                        status: status
                    },
                    success: function(response) {
                        if(response.status){
                            Swal.fire('Success', response.message, 'success').then(() => {
                                location.reload();
                            });
                        } else {
                            Swal.fire('Error', response.message, 'error');
                        }
                    },
                    error: function(xhr) {
                        Swal.fire('Error', 'কিছু সমস্যা হয়েছে', 'error');
                    }
                });
            }
        });

        // ডিলিট কনফার্মেশন
        $(document).on("click", ".remove-item-btn", function (e) {
            e.preventDefault();
            var link = $(this).attr('href');

            Swal.fire({
                title: "Are you sure?",
                text: "You can't restore the item",
                icon: "warning",
                showCancelButton: true,
                confirmButtonText: "Yes, delete",
                cancelButtonText: "Cancel",
                buttonsStyling: false,
                customClass: {
                    confirmButton: 'btn btn-primary w-xs me-2 mt-2',
                    cancelButton: 'btn btn-danger w-xs mt-2'
                }
            }).then((result) => {
                if (result.isConfirmed) {
                    Swal.fire({
                        title: "Deleted!",
                        text: "Item has been deleted.",
                        icon: "success",
                        confirmButtonClass: "btn btn-primary w-xs mt-2",
                        buttonsStyling: false
                    }).then(() => {
                        window.location.href = link;
                    });
                }
            });
        });
    </script>
@endpush
